/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1ValidatingWebhook;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ValidatingWebhookConfiguration describes the configuration of and admission webhook that accept or reject and object without changing it.")
public class V1ValidatingWebhookConfiguration {
    public static final String SERIALIZED_NAME_API_VERSION = "apiVersion";
    @SerializedName(value="apiVersion")
    private String apiVersion;
    public static final String SERIALIZED_NAME_KIND = "kind";
    @SerializedName(value="kind")
    private String kind;
    public static final String SERIALIZED_NAME_METADATA = "metadata";
    @SerializedName(value="metadata")
    private V1ObjectMeta metadata;
    public static final String SERIALIZED_NAME_WEBHOOKS = "webhooks";
    @SerializedName(value="webhooks")
    private List<V1ValidatingWebhook> webhooks = null;

    public V1ValidatingWebhookConfiguration apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1ValidatingWebhookConfiguration kind(String kind) {
        this.kind = kind;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds")
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1ValidatingWebhookConfiguration metadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public V1ValidatingWebhookConfiguration webhooks(List<V1ValidatingWebhook> webhooks) {
        this.webhooks = webhooks;
        return this;
    }

    public V1ValidatingWebhookConfiguration addWebhooksItem(V1ValidatingWebhook webhooksItem) {
        if (this.webhooks == null) {
            this.webhooks = new ArrayList<V1ValidatingWebhook>();
        }
        this.webhooks.add(webhooksItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Webhooks is a list of webhooks and the affected resources and operations.")
    public List<V1ValidatingWebhook> getWebhooks() {
        return this.webhooks;
    }

    public void setWebhooks(List<V1ValidatingWebhook> webhooks) {
        this.webhooks = webhooks;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ValidatingWebhookConfiguration v1ValidatingWebhookConfiguration = (V1ValidatingWebhookConfiguration)o;
        return Objects.equals(this.apiVersion, v1ValidatingWebhookConfiguration.apiVersion) && Objects.equals(this.kind, v1ValidatingWebhookConfiguration.kind) && Objects.equals(this.metadata, v1ValidatingWebhookConfiguration.metadata) && Objects.equals(this.webhooks, v1ValidatingWebhookConfiguration.webhooks);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.webhooks);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ValidatingWebhookConfiguration {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    webhooks: ").append(this.toIndentedString(this.webhooks)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

