/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1LocalObjectReference;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1ObjectReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="ServiceAccount binds together: * a name, understood by users, and perhaps by peripheral systems, for an identity * a principal that can be authenticated and authorized * a set of secrets")
public class V1ServiceAccount {
    public static final String SERIALIZED_NAME_API_VERSION = "apiVersion";
    @SerializedName(value="apiVersion")
    private String apiVersion;
    public static final String SERIALIZED_NAME_AUTOMOUNT_SERVICE_ACCOUNT_TOKEN = "automountServiceAccountToken";
    @SerializedName(value="automountServiceAccountToken")
    private Boolean automountServiceAccountToken;
    public static final String SERIALIZED_NAME_IMAGE_PULL_SECRETS = "imagePullSecrets";
    @SerializedName(value="imagePullSecrets")
    private List<V1LocalObjectReference> imagePullSecrets = null;
    public static final String SERIALIZED_NAME_KIND = "kind";
    @SerializedName(value="kind")
    private String kind;
    public static final String SERIALIZED_NAME_METADATA = "metadata";
    @SerializedName(value="metadata")
    private V1ObjectMeta metadata;
    public static final String SERIALIZED_NAME_SECRETS = "secrets";
    @SerializedName(value="secrets")
    private List<V1ObjectReference> secrets = null;

    public V1ServiceAccount apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1ServiceAccount automountServiceAccountToken(Boolean automountServiceAccountToken) {
        this.automountServiceAccountToken = automountServiceAccountToken;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="AutomountServiceAccountToken indicates whether pods running as this service account should have an API token automatically mounted. Can be overridden at the pod level.")
    public Boolean getAutomountServiceAccountToken() {
        return this.automountServiceAccountToken;
    }

    public void setAutomountServiceAccountToken(Boolean automountServiceAccountToken) {
        this.automountServiceAccountToken = automountServiceAccountToken;
    }

    public V1ServiceAccount imagePullSecrets(List<V1LocalObjectReference> imagePullSecrets) {
        this.imagePullSecrets = imagePullSecrets;
        return this;
    }

    public V1ServiceAccount addImagePullSecretsItem(V1LocalObjectReference imagePullSecretsItem) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList<V1LocalObjectReference>();
        }
        this.imagePullSecrets.add(imagePullSecretsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ImagePullSecrets is a list of references to secrets in the same namespace to use for pulling any images in pods that reference this ServiceAccount. ImagePullSecrets are distinct from Secrets because Secrets can be mounted in the pod, but ImagePullSecrets are only accessed by the kubelet. More info: https://kubernetes.io/docs/concepts/containers/images/#specifying-imagepullsecrets-on-a-pod")
    public List<V1LocalObjectReference> getImagePullSecrets() {
        return this.imagePullSecrets;
    }

    public void setImagePullSecrets(List<V1LocalObjectReference> imagePullSecrets) {
        this.imagePullSecrets = imagePullSecrets;
    }

    public V1ServiceAccount kind(String kind) {
        this.kind = kind;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds")
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1ServiceAccount metadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public V1ServiceAccount secrets(List<V1ObjectReference> secrets) {
        this.secrets = secrets;
        return this;
    }

    public V1ServiceAccount addSecretsItem(V1ObjectReference secretsItem) {
        if (this.secrets == null) {
            this.secrets = new ArrayList<V1ObjectReference>();
        }
        this.secrets.add(secretsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Secrets is the list of secrets allowed to be used by pods running using this ServiceAccount. More info: https://kubernetes.io/docs/concepts/configuration/secret")
    public List<V1ObjectReference> getSecrets() {
        return this.secrets;
    }

    public void setSecrets(List<V1ObjectReference> secrets) {
        this.secrets = secrets;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ServiceAccount v1ServiceAccount = (V1ServiceAccount)o;
        return Objects.equals(this.apiVersion, v1ServiceAccount.apiVersion) && Objects.equals(this.automountServiceAccountToken, v1ServiceAccount.automountServiceAccountToken) && Objects.equals(this.imagePullSecrets, v1ServiceAccount.imagePullSecrets) && Objects.equals(this.kind, v1ServiceAccount.kind) && Objects.equals(this.metadata, v1ServiceAccount.metadata) && Objects.equals(this.secrets, v1ServiceAccount.secrets);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.automountServiceAccountToken, this.imagePullSecrets, this.kind, this.metadata, this.secrets);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ServiceAccount {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    automountServiceAccountToken: ").append(this.toIndentedString(this.automountServiceAccountToken)).append("\n");
        sb.append("    imagePullSecrets: ").append(this.toIndentedString(this.imagePullSecrets)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    secrets: ").append(this.toIndentedString(this.secrets)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

