/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.PolicyV1beta1IDRange;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="SupplementalGroupsStrategyOptions defines the strategy type and options used to create the strategy.")
public class PolicyV1beta1SupplementalGroupsStrategyOptions {
    public static final String SERIALIZED_NAME_RANGES = "ranges";
    @SerializedName(value="ranges")
    private List<PolicyV1beta1IDRange> ranges = null;
    public static final String SERIALIZED_NAME_RULE = "rule";
    @SerializedName(value="rule")
    private String rule;

    public PolicyV1beta1SupplementalGroupsStrategyOptions ranges(List<PolicyV1beta1IDRange> ranges) {
        this.ranges = ranges;
        return this;
    }

    public PolicyV1beta1SupplementalGroupsStrategyOptions addRangesItem(PolicyV1beta1IDRange rangesItem) {
        if (this.ranges == null) {
            this.ranges = new ArrayList<PolicyV1beta1IDRange>();
        }
        this.ranges.add(rangesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ranges are the allowed ranges of supplemental groups.  If you would like to force a single supplemental group then supply a single range with the same start and end. Required for MustRunAs.")
    public List<PolicyV1beta1IDRange> getRanges() {
        return this.ranges;
    }

    public void setRanges(List<PolicyV1beta1IDRange> ranges) {
        this.ranges = ranges;
    }

    public PolicyV1beta1SupplementalGroupsStrategyOptions rule(String rule) {
        this.rule = rule;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="rule is the strategy that will dictate what supplemental groups is used in the SecurityContext.")
    public String getRule() {
        return this.rule;
    }

    public void setRule(String rule) {
        this.rule = rule;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PolicyV1beta1SupplementalGroupsStrategyOptions policyV1beta1SupplementalGroupsStrategyOptions = (PolicyV1beta1SupplementalGroupsStrategyOptions)o;
        return Objects.equals(this.ranges, policyV1beta1SupplementalGroupsStrategyOptions.ranges) && Objects.equals(this.rule, policyV1beta1SupplementalGroupsStrategyOptions.rule);
    }

    public int hashCode() {
        return Objects.hash(this.ranges, this.rule);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PolicyV1beta1SupplementalGroupsStrategyOptions {\n");
        sb.append("    ranges: ").append(this.toIndentedString(this.ranges)).append("\n");
        sb.append("    rule: ").append(this.toIndentedString(this.rule)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

