/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="IngressTLS describes the transport layer security associated with an Ingress.")
public class NetworkingV1beta1IngressTLS {
    public static final String SERIALIZED_NAME_HOSTS = "hosts";
    @SerializedName(value="hosts")
    private List<String> hosts = null;
    public static final String SERIALIZED_NAME_SECRET_NAME = "secretName";
    @SerializedName(value="secretName")
    private String secretName;

    public NetworkingV1beta1IngressTLS hosts(List<String> hosts) {
        this.hosts = hosts;
        return this;
    }

    public NetworkingV1beta1IngressTLS addHostsItem(String hostsItem) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<String>();
        }
        this.hosts.add(hostsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Hosts are a list of hosts included in the TLS certificate. The values in this list must match the name/s used in the tlsSecret. Defaults to the wildcard host setting for the loadbalancer controller fulfilling this Ingress, if left unspecified.")
    public List<String> getHosts() {
        return this.hosts;
    }

    public void setHosts(List<String> hosts) {
        this.hosts = hosts;
    }

    public NetworkingV1beta1IngressTLS secretName(String secretName) {
        this.secretName = secretName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="SecretName is the name of the secret used to terminate SSL traffic on 443. Field is left optional to allow SSL routing based on SNI hostname alone. If the SNI host in a listener conflicts with the \"Host\" header field used by an IngressRule, the SNI host is used for termination and value of the Host header is used for routing.")
    public String getSecretName() {
        return this.secretName;
    }

    public void setSecretName(String secretName) {
        this.secretName = secretName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetworkingV1beta1IngressTLS networkingV1beta1IngressTLS = (NetworkingV1beta1IngressTLS)o;
        return Objects.equals(this.hosts, networkingV1beta1IngressTLS.hosts) && Objects.equals(this.secretName, networkingV1beta1IngressTLS.secretName);
    }

    public int hashCode() {
        return Objects.hash(this.hosts, this.secretName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NetworkingV1beta1IngressTLS {\n");
        sb.append("    hosts: ").append(this.toIndentedString(this.hosts)).append("\n");
        sb.append("    secretName: ").append(this.toIndentedString(this.secretName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

