/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.custom.Quantity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="MetricTarget defines the target value, average value, or average utilization of a specific metric")
public class V2beta2MetricTarget {
    @SerializedName(value="averageUtilization")
    private Integer averageUtilization = null;
    @SerializedName(value="averageValue")
    private Quantity averageValue = null;
    @SerializedName(value="type")
    private String type = null;
    @SerializedName(value="value")
    private Quantity value = null;

    public V2beta2MetricTarget averageUtilization(Integer averageUtilization) {
        this.averageUtilization = averageUtilization;
        return this;
    }

    @ApiModelProperty(value="averageUtilization is the target value of the average of the resource metric across all relevant pods, represented as a percentage of the requested value of the resource for the pods. Currently only valid for Resource metric source type")
    public Integer getAverageUtilization() {
        return this.averageUtilization;
    }

    public void setAverageUtilization(Integer averageUtilization) {
        this.averageUtilization = averageUtilization;
    }

    public V2beta2MetricTarget averageValue(Quantity averageValue) {
        this.averageValue = averageValue;
        return this;
    }

    @ApiModelProperty(value="averageValue is the target value of the average of the metric across all relevant pods (as a quantity)")
    public Quantity getAverageValue() {
        return this.averageValue;
    }

    public void setAverageValue(Quantity averageValue) {
        this.averageValue = averageValue;
    }

    public V2beta2MetricTarget type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="type represents whether the metric type is Utilization, Value, or AverageValue")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public V2beta2MetricTarget value(Quantity value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(value="value is the target value of the metric (as a quantity).")
    public Quantity getValue() {
        return this.value;
    }

    public void setValue(Quantity value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V2beta2MetricTarget v2beta2MetricTarget = (V2beta2MetricTarget)o;
        return Objects.equals(this.averageUtilization, v2beta2MetricTarget.averageUtilization) && Objects.equals(this.averageValue, v2beta2MetricTarget.averageValue) && Objects.equals(this.type, v2beta2MetricTarget.type) && Objects.equals(this.value, v2beta2MetricTarget.value);
    }

    public int hashCode() {
        return Objects.hash(this.averageUtilization, this.averageValue, this.type, this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V2beta2MetricTarget {\n");
        sb.append("    averageUtilization: ").append(this.toIndentedString(this.averageUtilization)).append("\n");
        sb.append("    averageValue: ").append(this.toIndentedString(this.averageValue)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

