/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1beta1DaemonSetCondition;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="DaemonSetStatus represents the current status of a daemon set.")
public class V1beta1DaemonSetStatus {
    @SerializedName(value="collisionCount")
    private Integer collisionCount = null;
    @SerializedName(value="conditions")
    private List<V1beta1DaemonSetCondition> conditions = null;
    @SerializedName(value="currentNumberScheduled")
    private Integer currentNumberScheduled = null;
    @SerializedName(value="desiredNumberScheduled")
    private Integer desiredNumberScheduled = null;
    @SerializedName(value="numberAvailable")
    private Integer numberAvailable = null;
    @SerializedName(value="numberMisscheduled")
    private Integer numberMisscheduled = null;
    @SerializedName(value="numberReady")
    private Integer numberReady = null;
    @SerializedName(value="numberUnavailable")
    private Integer numberUnavailable = null;
    @SerializedName(value="observedGeneration")
    private Long observedGeneration = null;
    @SerializedName(value="updatedNumberScheduled")
    private Integer updatedNumberScheduled = null;

    public V1beta1DaemonSetStatus collisionCount(Integer collisionCount) {
        this.collisionCount = collisionCount;
        return this;
    }

    @ApiModelProperty(value="Count of hash collisions for the DaemonSet. The DaemonSet controller uses this field as a collision avoidance mechanism when it needs to create the name for the newest ControllerRevision.")
    public Integer getCollisionCount() {
        return this.collisionCount;
    }

    public void setCollisionCount(Integer collisionCount) {
        this.collisionCount = collisionCount;
    }

    public V1beta1DaemonSetStatus conditions(List<V1beta1DaemonSetCondition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public V1beta1DaemonSetStatus addConditionsItem(V1beta1DaemonSetCondition conditionsItem) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1beta1DaemonSetCondition>();
        }
        this.conditions.add(conditionsItem);
        return this;
    }

    @ApiModelProperty(value="Represents the latest available observations of a DaemonSet's current state.")
    public List<V1beta1DaemonSetCondition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<V1beta1DaemonSetCondition> conditions) {
        this.conditions = conditions;
    }

    public V1beta1DaemonSetStatus currentNumberScheduled(Integer currentNumberScheduled) {
        this.currentNumberScheduled = currentNumberScheduled;
        return this;
    }

    @ApiModelProperty(required=true, value="The number of nodes that are running at least 1 daemon pod and are supposed to run the daemon pod. More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/")
    public Integer getCurrentNumberScheduled() {
        return this.currentNumberScheduled;
    }

    public void setCurrentNumberScheduled(Integer currentNumberScheduled) {
        this.currentNumberScheduled = currentNumberScheduled;
    }

    public V1beta1DaemonSetStatus desiredNumberScheduled(Integer desiredNumberScheduled) {
        this.desiredNumberScheduled = desiredNumberScheduled;
        return this;
    }

    @ApiModelProperty(required=true, value="The total number of nodes that should be running the daemon pod (including nodes correctly running the daemon pod). More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/")
    public Integer getDesiredNumberScheduled() {
        return this.desiredNumberScheduled;
    }

    public void setDesiredNumberScheduled(Integer desiredNumberScheduled) {
        this.desiredNumberScheduled = desiredNumberScheduled;
    }

    public V1beta1DaemonSetStatus numberAvailable(Integer numberAvailable) {
        this.numberAvailable = numberAvailable;
        return this;
    }

    @ApiModelProperty(value="The number of nodes that should be running the daemon pod and have one or more of the daemon pod running and available (ready for at least spec.minReadySeconds)")
    public Integer getNumberAvailable() {
        return this.numberAvailable;
    }

    public void setNumberAvailable(Integer numberAvailable) {
        this.numberAvailable = numberAvailable;
    }

    public V1beta1DaemonSetStatus numberMisscheduled(Integer numberMisscheduled) {
        this.numberMisscheduled = numberMisscheduled;
        return this;
    }

    @ApiModelProperty(required=true, value="The number of nodes that are running the daemon pod, but are not supposed to run the daemon pod. More info: https://kubernetes.io/docs/concepts/workloads/controllers/daemonset/")
    public Integer getNumberMisscheduled() {
        return this.numberMisscheduled;
    }

    public void setNumberMisscheduled(Integer numberMisscheduled) {
        this.numberMisscheduled = numberMisscheduled;
    }

    public V1beta1DaemonSetStatus numberReady(Integer numberReady) {
        this.numberReady = numberReady;
        return this;
    }

    @ApiModelProperty(required=true, value="The number of nodes that should be running the daemon pod and have one or more of the daemon pod running and ready.")
    public Integer getNumberReady() {
        return this.numberReady;
    }

    public void setNumberReady(Integer numberReady) {
        this.numberReady = numberReady;
    }

    public V1beta1DaemonSetStatus numberUnavailable(Integer numberUnavailable) {
        this.numberUnavailable = numberUnavailable;
        return this;
    }

    @ApiModelProperty(value="The number of nodes that should be running the daemon pod and have none of the daemon pod running and available (ready for at least spec.minReadySeconds)")
    public Integer getNumberUnavailable() {
        return this.numberUnavailable;
    }

    public void setNumberUnavailable(Integer numberUnavailable) {
        this.numberUnavailable = numberUnavailable;
    }

    public V1beta1DaemonSetStatus observedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return this;
    }

    @ApiModelProperty(value="The most recent generation observed by the daemon set controller.")
    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public void setObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
    }

    public V1beta1DaemonSetStatus updatedNumberScheduled(Integer updatedNumberScheduled) {
        this.updatedNumberScheduled = updatedNumberScheduled;
        return this;
    }

    @ApiModelProperty(value="The total number of nodes that are running updated daemon pod")
    public Integer getUpdatedNumberScheduled() {
        return this.updatedNumberScheduled;
    }

    public void setUpdatedNumberScheduled(Integer updatedNumberScheduled) {
        this.updatedNumberScheduled = updatedNumberScheduled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1DaemonSetStatus v1beta1DaemonSetStatus = (V1beta1DaemonSetStatus)o;
        return Objects.equals(this.collisionCount, v1beta1DaemonSetStatus.collisionCount) && Objects.equals(this.conditions, v1beta1DaemonSetStatus.conditions) && Objects.equals(this.currentNumberScheduled, v1beta1DaemonSetStatus.currentNumberScheduled) && Objects.equals(this.desiredNumberScheduled, v1beta1DaemonSetStatus.desiredNumberScheduled) && Objects.equals(this.numberAvailable, v1beta1DaemonSetStatus.numberAvailable) && Objects.equals(this.numberMisscheduled, v1beta1DaemonSetStatus.numberMisscheduled) && Objects.equals(this.numberReady, v1beta1DaemonSetStatus.numberReady) && Objects.equals(this.numberUnavailable, v1beta1DaemonSetStatus.numberUnavailable) && Objects.equals(this.observedGeneration, v1beta1DaemonSetStatus.observedGeneration) && Objects.equals(this.updatedNumberScheduled, v1beta1DaemonSetStatus.updatedNumberScheduled);
    }

    public int hashCode() {
        return Objects.hash(this.collisionCount, this.conditions, this.currentNumberScheduled, this.desiredNumberScheduled, this.numberAvailable, this.numberMisscheduled, this.numberReady, this.numberUnavailable, this.observedGeneration, this.updatedNumberScheduled);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1DaemonSetStatus {\n");
        sb.append("    collisionCount: ").append(this.toIndentedString(this.collisionCount)).append("\n");
        sb.append("    conditions: ").append(this.toIndentedString(this.conditions)).append("\n");
        sb.append("    currentNumberScheduled: ").append(this.toIndentedString(this.currentNumberScheduled)).append("\n");
        sb.append("    desiredNumberScheduled: ").append(this.toIndentedString(this.desiredNumberScheduled)).append("\n");
        sb.append("    numberAvailable: ").append(this.toIndentedString(this.numberAvailable)).append("\n");
        sb.append("    numberMisscheduled: ").append(this.toIndentedString(this.numberMisscheduled)).append("\n");
        sb.append("    numberReady: ").append(this.toIndentedString(this.numberReady)).append("\n");
        sb.append("    numberUnavailable: ").append(this.toIndentedString(this.numberUnavailable)).append("\n");
        sb.append("    observedGeneration: ").append(this.toIndentedString(this.observedGeneration)).append("\n");
        sb.append("    updatedNumberScheduled: ").append(this.toIndentedString(this.updatedNumberScheduled)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

