/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1beta1CustomResourceColumnDefinition;
import io.kubernetes.client.models.V1beta1CustomResourceSubresources;
import io.kubernetes.client.models.V1beta1CustomResourceValidation;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="CustomResourceDefinitionVersion describes a version for CRD.")
public class V1beta1CustomResourceDefinitionVersion {
    @SerializedName(value="additionalPrinterColumns")
    private List<V1beta1CustomResourceColumnDefinition> additionalPrinterColumns = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="schema")
    private V1beta1CustomResourceValidation schema = null;
    @SerializedName(value="served")
    private Boolean served = null;
    @SerializedName(value="storage")
    private Boolean storage = null;
    @SerializedName(value="subresources")
    private V1beta1CustomResourceSubresources subresources = null;

    public V1beta1CustomResourceDefinitionVersion additionalPrinterColumns(List<V1beta1CustomResourceColumnDefinition> additionalPrinterColumns) {
        this.additionalPrinterColumns = additionalPrinterColumns;
        return this;
    }

    public V1beta1CustomResourceDefinitionVersion addAdditionalPrinterColumnsItem(V1beta1CustomResourceColumnDefinition additionalPrinterColumnsItem) {
        if (this.additionalPrinterColumns == null) {
            this.additionalPrinterColumns = new ArrayList<V1beta1CustomResourceColumnDefinition>();
        }
        this.additionalPrinterColumns.add(additionalPrinterColumnsItem);
        return this;
    }

    @ApiModelProperty(value="AdditionalPrinterColumns are additional columns shown e.g. in kubectl next to the name. Defaults to a created-at column. Top-level and per-version columns are mutually exclusive. Per-version columns must not all be set to identical values (top-level columns should be used instead) This field is alpha-level and is only honored by servers that enable the CustomResourceWebhookConversion feature. NOTE: CRDs created prior to 1.13 populated the top-level additionalPrinterColumns field by default. To apply an update that changes to per-version additionalPrinterColumns, the top-level additionalPrinterColumns field must be explicitly set to null")
    public List<V1beta1CustomResourceColumnDefinition> getAdditionalPrinterColumns() {
        return this.additionalPrinterColumns;
    }

    public void setAdditionalPrinterColumns(List<V1beta1CustomResourceColumnDefinition> additionalPrinterColumns) {
        this.additionalPrinterColumns = additionalPrinterColumns;
    }

    public V1beta1CustomResourceDefinitionVersion name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Name is the version name, e.g. \u201cv1\u201d, \u201cv2beta1\u201d, etc.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1beta1CustomResourceDefinitionVersion schema(V1beta1CustomResourceValidation schema) {
        this.schema = schema;
        return this;
    }

    @ApiModelProperty(value="Schema describes the schema for CustomResource used in validation, pruning, and defaulting. Top-level and per-version schemas are mutually exclusive. Per-version schemas must not all be set to identical values (top-level validation schema should be used instead) This field is alpha-level and is only honored by servers that enable the CustomResourceWebhookConversion feature.")
    public V1beta1CustomResourceValidation getSchema() {
        return this.schema;
    }

    public void setSchema(V1beta1CustomResourceValidation schema) {
        this.schema = schema;
    }

    public V1beta1CustomResourceDefinitionVersion served(Boolean served) {
        this.served = served;
        return this;
    }

    @ApiModelProperty(required=true, value="Served is a flag enabling/disabling this version from being served via REST APIs")
    public Boolean isServed() {
        return this.served;
    }

    public void setServed(Boolean served) {
        this.served = served;
    }

    public V1beta1CustomResourceDefinitionVersion storage(Boolean storage) {
        this.storage = storage;
        return this;
    }

    @ApiModelProperty(required=true, value="Storage flags the version as storage version. There must be exactly one flagged as storage version.")
    public Boolean isStorage() {
        return this.storage;
    }

    public void setStorage(Boolean storage) {
        this.storage = storage;
    }

    public V1beta1CustomResourceDefinitionVersion subresources(V1beta1CustomResourceSubresources subresources) {
        this.subresources = subresources;
        return this;
    }

    @ApiModelProperty(value="Subresources describes the subresources for CustomResource Top-level and per-version subresources are mutually exclusive. Per-version subresources must not all be set to identical values (top-level subresources should be used instead) This field is alpha-level and is only honored by servers that enable the CustomResourceWebhookConversion feature.")
    public V1beta1CustomResourceSubresources getSubresources() {
        return this.subresources;
    }

    public void setSubresources(V1beta1CustomResourceSubresources subresources) {
        this.subresources = subresources;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1CustomResourceDefinitionVersion v1beta1CustomResourceDefinitionVersion = (V1beta1CustomResourceDefinitionVersion)o;
        return Objects.equals(this.additionalPrinterColumns, v1beta1CustomResourceDefinitionVersion.additionalPrinterColumns) && Objects.equals(this.name, v1beta1CustomResourceDefinitionVersion.name) && Objects.equals(this.schema, v1beta1CustomResourceDefinitionVersion.schema) && Objects.equals(this.served, v1beta1CustomResourceDefinitionVersion.served) && Objects.equals(this.storage, v1beta1CustomResourceDefinitionVersion.storage) && Objects.equals(this.subresources, v1beta1CustomResourceDefinitionVersion.subresources);
    }

    public int hashCode() {
        return Objects.hash(this.additionalPrinterColumns, this.name, this.schema, this.served, this.storage, this.subresources);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1CustomResourceDefinitionVersion {\n");
        sb.append("    additionalPrinterColumns: ").append(this.toIndentedString(this.additionalPrinterColumns)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    schema: ").append(this.toIndentedString(this.schema)).append("\n");
        sb.append("    served: ").append(this.toIndentedString(this.served)).append("\n");
        sb.append("    storage: ").append(this.toIndentedString(this.storage)).append("\n");
        sb.append("    subresources: ").append(this.toIndentedString(this.subresources)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

