/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.fluent.Predicate;
import io.kubernetes.client.models.ApiextensionsV1beta1WebhookClientConfig;
import io.kubernetes.client.models.ApiextensionsV1beta1WebhookClientConfigBuilder;
import io.kubernetes.client.models.ApiextensionsV1beta1WebhookClientConfigFluentImpl;
import io.kubernetes.client.models.V1beta1CustomResourceConversion;
import io.kubernetes.client.models.V1beta1CustomResourceConversionFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class V1beta1CustomResourceConversionFluentImpl<A extends V1beta1CustomResourceConversionFluent<A>>
extends BaseFluent<A>
implements V1beta1CustomResourceConversionFluent<A> {
    private List<String> conversionReviewVersions;
    private String strategy;
    private ApiextensionsV1beta1WebhookClientConfigBuilder webhookClientConfig;

    public V1beta1CustomResourceConversionFluentImpl() {
    }

    public V1beta1CustomResourceConversionFluentImpl(V1beta1CustomResourceConversion instance) {
        this.withConversionReviewVersions(instance.getConversionReviewVersions());
        this.withStrategy(instance.getStrategy());
        this.withWebhookClientConfig(instance.getWebhookClientConfig());
    }

    @Override
    public A addToConversionReviewVersions(int index, String item) {
        if (this.conversionReviewVersions == null) {
            this.conversionReviewVersions = new ArrayList<String>();
        }
        this.conversionReviewVersions.add(index, item);
        return (A)this;
    }

    @Override
    public A setToConversionReviewVersions(int index, String item) {
        if (this.conversionReviewVersions == null) {
            this.conversionReviewVersions = new ArrayList<String>();
        }
        this.conversionReviewVersions.set(index, item);
        return (A)this;
    }

    @Override
    public A addToConversionReviewVersions(String ... items) {
        if (this.conversionReviewVersions == null) {
            this.conversionReviewVersions = new ArrayList<String>();
        }
        for (String item : items) {
            this.conversionReviewVersions.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToConversionReviewVersions(Collection<String> items) {
        if (this.conversionReviewVersions == null) {
            this.conversionReviewVersions = new ArrayList<String>();
        }
        for (String item : items) {
            this.conversionReviewVersions.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromConversionReviewVersions(String ... items) {
        for (String item : items) {
            if (this.conversionReviewVersions == null) continue;
            this.conversionReviewVersions.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConversionReviewVersions(Collection<String> items) {
        for (String item : items) {
            if (this.conversionReviewVersions == null) continue;
            this.conversionReviewVersions.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getConversionReviewVersions() {
        return this.conversionReviewVersions;
    }

    @Override
    public String getConversionReviewVersion(int index) {
        return this.conversionReviewVersions.get(index);
    }

    @Override
    public String getFirstConversionReviewVersion() {
        return this.conversionReviewVersions.get(0);
    }

    @Override
    public String getLastConversionReviewVersion() {
        return this.conversionReviewVersions.get(this.conversionReviewVersions.size() - 1);
    }

    @Override
    public String getMatchingConversionReviewVersion(Predicate<String> predicate) {
        for (String item : this.conversionReviewVersions) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingConversionReviewVersion(Predicate<String> predicate) {
        for (String item : this.conversionReviewVersions) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConversionReviewVersions(List<String> conversionReviewVersions) {
        if (this.conversionReviewVersions != null) {
            this._visitables.get("conversionReviewVersions").removeAll(this.conversionReviewVersions);
        }
        if (conversionReviewVersions != null) {
            this.conversionReviewVersions = new ArrayList<String>();
            for (String item : conversionReviewVersions) {
                this.addToConversionReviewVersions(item);
            }
        } else {
            this.conversionReviewVersions = null;
        }
        return (A)this;
    }

    @Override
    public A withConversionReviewVersions(String ... conversionReviewVersions) {
        if (this.conversionReviewVersions != null) {
            this.conversionReviewVersions.clear();
        }
        if (conversionReviewVersions != null) {
            for (String item : conversionReviewVersions) {
                this.addToConversionReviewVersions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConversionReviewVersions() {
        return this.conversionReviewVersions != null && !this.conversionReviewVersions.isEmpty();
    }

    @Override
    public A addNewConversionReviewVersion(String arg1) {
        return this.addToConversionReviewVersions(new String(arg1));
    }

    @Override
    public A addNewConversionReviewVersion(StringBuilder arg1) {
        return this.addToConversionReviewVersions(new String(arg1));
    }

    @Override
    public A addNewConversionReviewVersion(StringBuffer arg1) {
        return this.addToConversionReviewVersions(new String(arg1));
    }

    @Override
    public String getStrategy() {
        return this.strategy;
    }

    @Override
    public A withStrategy(String strategy) {
        this.strategy = strategy;
        return (A)this;
    }

    @Override
    public Boolean hasStrategy() {
        return this.strategy != null;
    }

    @Override
    public A withNewStrategy(String arg1) {
        return this.withStrategy(new String(arg1));
    }

    @Override
    public A withNewStrategy(StringBuilder arg1) {
        return this.withStrategy(new String(arg1));
    }

    @Override
    public A withNewStrategy(StringBuffer arg1) {
        return this.withStrategy(new String(arg1));
    }

    @Override
    @Deprecated
    public ApiextensionsV1beta1WebhookClientConfig getWebhookClientConfig() {
        return this.webhookClientConfig != null ? this.webhookClientConfig.build() : null;
    }

    @Override
    public ApiextensionsV1beta1WebhookClientConfig buildWebhookClientConfig() {
        return this.webhookClientConfig != null ? this.webhookClientConfig.build() : null;
    }

    @Override
    public A withWebhookClientConfig(ApiextensionsV1beta1WebhookClientConfig webhookClientConfig) {
        this._visitables.get("webhookClientConfig").remove(this.webhookClientConfig);
        if (webhookClientConfig != null) {
            this.webhookClientConfig = new ApiextensionsV1beta1WebhookClientConfigBuilder(webhookClientConfig);
            this._visitables.get("webhookClientConfig").add(this.webhookClientConfig);
        }
        return (A)this;
    }

    @Override
    public Boolean hasWebhookClientConfig() {
        return this.webhookClientConfig != null;
    }

    @Override
    public V1beta1CustomResourceConversionFluent.WebhookClientConfigNested<A> withNewWebhookClientConfig() {
        return new WebhookClientConfigNestedImpl();
    }

    @Override
    public V1beta1CustomResourceConversionFluent.WebhookClientConfigNested<A> withNewWebhookClientConfigLike(ApiextensionsV1beta1WebhookClientConfig item) {
        return new WebhookClientConfigNestedImpl(item);
    }

    @Override
    public V1beta1CustomResourceConversionFluent.WebhookClientConfigNested<A> editWebhookClientConfig() {
        return this.withNewWebhookClientConfigLike(this.getWebhookClientConfig());
    }

    @Override
    public V1beta1CustomResourceConversionFluent.WebhookClientConfigNested<A> editOrNewWebhookClientConfig() {
        return this.withNewWebhookClientConfigLike(this.getWebhookClientConfig() != null ? this.getWebhookClientConfig() : new ApiextensionsV1beta1WebhookClientConfigBuilder().build());
    }

    @Override
    public V1beta1CustomResourceConversionFluent.WebhookClientConfigNested<A> editOrNewWebhookClientConfigLike(ApiextensionsV1beta1WebhookClientConfig item) {
        return this.withNewWebhookClientConfigLike(this.getWebhookClientConfig() != null ? this.getWebhookClientConfig() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1beta1CustomResourceConversionFluentImpl that = (V1beta1CustomResourceConversionFluentImpl)o;
        if (this.conversionReviewVersions != null ? !this.conversionReviewVersions.equals(that.conversionReviewVersions) : that.conversionReviewVersions != null) {
            return false;
        }
        if (this.strategy != null ? !this.strategy.equals(that.strategy) : that.strategy != null) {
            return false;
        }
        return !(this.webhookClientConfig != null ? !this.webhookClientConfig.equals(that.webhookClientConfig) : that.webhookClientConfig != null);
    }

    public class WebhookClientConfigNestedImpl<N>
    extends ApiextensionsV1beta1WebhookClientConfigFluentImpl<V1beta1CustomResourceConversionFluent.WebhookClientConfigNested<N>>
    implements V1beta1CustomResourceConversionFluent.WebhookClientConfigNested<N>,
    Nested<N> {
        private final ApiextensionsV1beta1WebhookClientConfigBuilder builder;

        WebhookClientConfigNestedImpl(ApiextensionsV1beta1WebhookClientConfig item) {
            this.builder = new ApiextensionsV1beta1WebhookClientConfigBuilder(this, item);
        }

        WebhookClientConfigNestedImpl() {
            this.builder = new ApiextensionsV1beta1WebhookClientConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1beta1CustomResourceConversionFluentImpl.this.withWebhookClientConfig(this.builder.build());
        }

        @Override
        public N endWebhookClientConfig() {
            return this.and();
        }
    }
}

