/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1ListMeta;
import io.kubernetes.client.models.V1Namespace;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="NamespaceList is a list of Namespaces.")
public class V1NamespaceList {
    @SerializedName(value="apiVersion")
    private String apiVersion = null;
    @SerializedName(value="items")
    private List<V1Namespace> items = new ArrayList<V1Namespace>();
    @SerializedName(value="kind")
    private String kind = null;
    @SerializedName(value="metadata")
    private V1ListMeta metadata = null;

    public V1NamespaceList apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @ApiModelProperty(value="APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1NamespaceList items(List<V1Namespace> items) {
        this.items = items;
        return this;
    }

    public V1NamespaceList addItemsItem(V1Namespace itemsItem) {
        this.items.add(itemsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Items is the list of Namespace objects in the list. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/namespaces/")
    public List<V1Namespace> getItems() {
        return this.items;
    }

    public void setItems(List<V1Namespace> items) {
        this.items = items;
    }

    public V1NamespaceList kind(String kind) {
        this.kind = kind;
        return this;
    }

    @ApiModelProperty(value="Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds")
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1NamespaceList metadata(V1ListMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(value="Standard list metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds")
    public V1ListMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(V1ListMeta metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1NamespaceList v1NamespaceList = (V1NamespaceList)o;
        return Objects.equals(this.apiVersion, v1NamespaceList.apiVersion) && Objects.equals(this.items, v1NamespaceList.items) && Objects.equals(this.kind, v1NamespaceList.kind) && Objects.equals(this.metadata, v1NamespaceList.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.items, this.kind, this.metadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1NamespaceList {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

