/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Represents a host path mapped into a pod. Host path volumes do not support ownership management or SELinux relabeling.")
public class V1HostPathVolumeSource {
    @SerializedName(value="path")
    private String path = null;
    @SerializedName(value="type")
    private String type = null;

    public V1HostPathVolumeSource path(String path) {
        this.path = path;
        return this;
    }

    @ApiModelProperty(required=true, value="Path of the directory on the host. If the path is a symlink, it will follow the link to the real path. More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath")
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public V1HostPathVolumeSource type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="Type for HostPath Volume Defaults to \"\" More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1HostPathVolumeSource v1HostPathVolumeSource = (V1HostPathVolumeSource)o;
        return Objects.equals(this.path, v1HostPathVolumeSource.path) && Objects.equals(this.type, v1HostPathVolumeSource.type);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1HostPathVolumeSource {\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

