/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.")
public class V1HostAlias {
    @SerializedName(value="hostnames")
    private List<String> hostnames = null;
    @SerializedName(value="ip")
    private String ip = null;

    public V1HostAlias hostnames(List<String> hostnames) {
        this.hostnames = hostnames;
        return this;
    }

    public V1HostAlias addHostnamesItem(String hostnamesItem) {
        if (this.hostnames == null) {
            this.hostnames = new ArrayList<String>();
        }
        this.hostnames.add(hostnamesItem);
        return this;
    }

    @ApiModelProperty(value="Hostnames for the above IP address.")
    public List<String> getHostnames() {
        return this.hostnames;
    }

    public void setHostnames(List<String> hostnames) {
        this.hostnames = hostnames;
    }

    public V1HostAlias ip(String ip) {
        this.ip = ip;
        return this;
    }

    @ApiModelProperty(value="IP address of the host file entry.")
    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1HostAlias v1HostAlias = (V1HostAlias)o;
        return Objects.equals(this.hostnames, v1HostAlias.hostnames) && Objects.equals(this.ip, v1HostAlias.ip);
    }

    public int hashCode() {
        return Objects.hash(this.hostnames, this.ip);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1HostAlias {\n");
        sb.append("    hostnames: ").append(this.toIndentedString(this.hostnames)).append("\n");
        sb.append("    ip: ").append(this.toIndentedString(this.ip)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

