package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V2beta1ExternalMetricStatusBuilder extends V2beta1ExternalMetricStatusFluentImpl<V2beta1ExternalMetricStatusBuilder> implements VisitableBuilder<V2beta1ExternalMetricStatus,V2beta1ExternalMetricStatusBuilder>{

    V2beta1ExternalMetricStatusFluent<?> fluent;
    Boolean validationEnabled;

    public V2beta1ExternalMetricStatusBuilder(){
            this(true);
    }
    public V2beta1ExternalMetricStatusBuilder(Boolean validationEnabled){
            this(new V2beta1ExternalMetricStatus(), validationEnabled);
    }
    public V2beta1ExternalMetricStatusBuilder(V2beta1ExternalMetricStatusFluent<?> fluent){
            this(fluent, true);
    }
    public V2beta1ExternalMetricStatusBuilder(V2beta1ExternalMetricStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V2beta1ExternalMetricStatus(), validationEnabled);
    }
    public V2beta1ExternalMetricStatusBuilder(V2beta1ExternalMetricStatusFluent<?> fluent,V2beta1ExternalMetricStatus instance){
            this(fluent, instance, true);
    }
    public V2beta1ExternalMetricStatusBuilder(V2beta1ExternalMetricStatusFluent<?> fluent,V2beta1ExternalMetricStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withCurrentAverageValue(instance.getCurrentAverageValue());

            fluent.withCurrentValue(instance.getCurrentValue());

            fluent.withMetricName(instance.getMetricName());

            fluent.withMetricSelector(instance.getMetricSelector());

            this.validationEnabled = validationEnabled; 
    }
    public V2beta1ExternalMetricStatusBuilder(V2beta1ExternalMetricStatus instance){
            this(instance,true);
    }
    public V2beta1ExternalMetricStatusBuilder(V2beta1ExternalMetricStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withCurrentAverageValue(instance.getCurrentAverageValue());

            this.withCurrentValue(instance.getCurrentValue());

            this.withMetricName(instance.getMetricName());

            this.withMetricSelector(instance.getMetricSelector());

            this.validationEnabled = validationEnabled; 
    }

    public V2beta1ExternalMetricStatus build(){
            V2beta1ExternalMetricStatus buildable = new V2beta1ExternalMetricStatus();
            buildable.setCurrentAverageValue(fluent.getCurrentAverageValue());
            buildable.setCurrentValue(fluent.getCurrentValue());
            buildable.setMetricName(fluent.getMetricName());
            buildable.setMetricSelector(fluent.getMetricSelector());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V2beta1ExternalMetricStatusBuilder that = (V2beta1ExternalMetricStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
