package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta2ReplicaSetBuilder extends V1beta2ReplicaSetFluentImpl<V1beta2ReplicaSetBuilder> implements VisitableBuilder<V1beta2ReplicaSet,V1beta2ReplicaSetBuilder>{

    V1beta2ReplicaSetFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta2ReplicaSetBuilder(){
            this(true);
    }
    public V1beta2ReplicaSetBuilder(Boolean validationEnabled){
            this(new V1beta2ReplicaSet(), validationEnabled);
    }
    public V1beta2ReplicaSetBuilder(V1beta2ReplicaSetFluent<?> fluent){
            this(fluent, true);
    }
    public V1beta2ReplicaSetBuilder(V1beta2ReplicaSetFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1beta2ReplicaSet(), validationEnabled);
    }
    public V1beta2ReplicaSetBuilder(V1beta2ReplicaSetFluent<?> fluent,V1beta2ReplicaSet instance){
            this(fluent, instance, true);
    }
    public V1beta2ReplicaSetBuilder(V1beta2ReplicaSetFluent<?> fluent,V1beta2ReplicaSet instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            fluent.withSpec(instance.getSpec());

            fluent.withStatus(instance.getStatus());

            this.validationEnabled = validationEnabled; 
    }
    public V1beta2ReplicaSetBuilder(V1beta2ReplicaSet instance){
            this(instance,true);
    }
    public V1beta2ReplicaSetBuilder(V1beta2ReplicaSet instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.withSpec(instance.getSpec());

            this.withStatus(instance.getStatus());

            this.validationEnabled = validationEnabled; 
    }

    public V1beta2ReplicaSet build(){
            V1beta2ReplicaSet buildable = new V1beta2ReplicaSet();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            buildable.setSpec(fluent.getSpec());
            buildable.setStatus(fluent.getStatus());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta2ReplicaSetBuilder that = (V1beta2ReplicaSetBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
