package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Fluent;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import java.lang.Integer;
import java.lang.Deprecated;
import java.lang.Boolean;

public interface V1beta2DeploymentSpecFluent<A extends V1beta2DeploymentSpecFluent<A>> extends Fluent<A>{


    public Integer getMinReadySeconds();
    public A withMinReadySeconds(Integer minReadySeconds);
    public Boolean hasMinReadySeconds();
    public A withNewMinReadySeconds(int arg1);
    public A withNewMinReadySeconds(String arg1);
    public Boolean isPaused();
    public A withPaused(Boolean paused);
    public Boolean hasPaused();
    public A withNewPaused(boolean arg1);
    public A withNewPaused(String arg1);
    public Integer getProgressDeadlineSeconds();
    public A withProgressDeadlineSeconds(Integer progressDeadlineSeconds);
    public Boolean hasProgressDeadlineSeconds();
    public A withNewProgressDeadlineSeconds(int arg1);
    public A withNewProgressDeadlineSeconds(String arg1);
    public Integer getReplicas();
    public A withReplicas(Integer replicas);
    public Boolean hasReplicas();
    public A withNewReplicas(int arg1);
    public A withNewReplicas(String arg1);
    public Integer getRevisionHistoryLimit();
    public A withRevisionHistoryLimit(Integer revisionHistoryLimit);
    public Boolean hasRevisionHistoryLimit();
    public A withNewRevisionHistoryLimit(int arg1);
    public A withNewRevisionHistoryLimit(String arg1);
    
/**
 * This method has been deprecated, please use method buildSelector instead.
 * @return The buildable object.
 */
@Deprecated public V1LabelSelector getSelector();
    public V1LabelSelector buildSelector();
    public A withSelector(V1LabelSelector selector);
    public Boolean hasSelector();
    public V1beta2DeploymentSpecFluent.SelectorNested<A> withNewSelector();
    public V1beta2DeploymentSpecFluent.SelectorNested<A> withNewSelectorLike(V1LabelSelector item);
    public V1beta2DeploymentSpecFluent.SelectorNested<A> editSelector();
    public V1beta2DeploymentSpecFluent.SelectorNested<A> editOrNewSelector();
    public V1beta2DeploymentSpecFluent.SelectorNested<A> editOrNewSelectorLike(V1LabelSelector item);
    
/**
 * This method has been deprecated, please use method buildStrategy instead.
 * @return The buildable object.
 */
@Deprecated public V1beta2DeploymentStrategy getStrategy();
    public V1beta2DeploymentStrategy buildStrategy();
    public A withStrategy(V1beta2DeploymentStrategy strategy);
    public Boolean hasStrategy();
    public V1beta2DeploymentSpecFluent.StrategyNested<A> withNewStrategy();
    public V1beta2DeploymentSpecFluent.StrategyNested<A> withNewStrategyLike(V1beta2DeploymentStrategy item);
    public V1beta2DeploymentSpecFluent.StrategyNested<A> editStrategy();
    public V1beta2DeploymentSpecFluent.StrategyNested<A> editOrNewStrategy();
    public V1beta2DeploymentSpecFluent.StrategyNested<A> editOrNewStrategyLike(V1beta2DeploymentStrategy item);
    
/**
 * This method has been deprecated, please use method buildTemplate instead.
 * @return The buildable object.
 */
@Deprecated public V1PodTemplateSpec getTemplate();
    public V1PodTemplateSpec buildTemplate();
    public A withTemplate(V1PodTemplateSpec template);
    public Boolean hasTemplate();
    public V1beta2DeploymentSpecFluent.TemplateNested<A> withNewTemplate();
    public V1beta2DeploymentSpecFluent.TemplateNested<A> withNewTemplateLike(V1PodTemplateSpec item);
    public V1beta2DeploymentSpecFluent.TemplateNested<A> editTemplate();
    public V1beta2DeploymentSpecFluent.TemplateNested<A> editOrNewTemplate();
    public V1beta2DeploymentSpecFluent.TemplateNested<A> editOrNewTemplateLike(V1PodTemplateSpec item);

    public interface SelectorNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1LabelSelectorFluent<V1beta2DeploymentSpecFluent.SelectorNested<N>>{

        
    public N and();    public N endSelector();
}
    public interface StrategyNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1beta2DeploymentStrategyFluent<V1beta2DeploymentSpecFluent.StrategyNested<N>>{

        
    public N and();    public N endStrategy();
}
    public interface TemplateNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1PodTemplateSpecFluent<V1beta2DeploymentSpecFluent.TemplateNested<N>>{

        
    public N and();    public N endTemplate();
}


}
