package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta2DeploymentSpecBuilder extends V1beta2DeploymentSpecFluentImpl<V1beta2DeploymentSpecBuilder> implements VisitableBuilder<V1beta2DeploymentSpec,V1beta2DeploymentSpecBuilder>{

    V1beta2DeploymentSpecFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta2DeploymentSpecBuilder(){
            this(true);
    }
    public V1beta2DeploymentSpecBuilder(Boolean validationEnabled){
            this(new V1beta2DeploymentSpec(), validationEnabled);
    }
    public V1beta2DeploymentSpecBuilder(V1beta2DeploymentSpecFluent<?> fluent){
            this(fluent, true);
    }
    public V1beta2DeploymentSpecBuilder(V1beta2DeploymentSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1beta2DeploymentSpec(), validationEnabled);
    }
    public V1beta2DeploymentSpecBuilder(V1beta2DeploymentSpecFluent<?> fluent,V1beta2DeploymentSpec instance){
            this(fluent, instance, true);
    }
    public V1beta2DeploymentSpecBuilder(V1beta2DeploymentSpecFluent<?> fluent,V1beta2DeploymentSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMinReadySeconds(instance.getMinReadySeconds());

            fluent.withPaused(instance.isPaused());

            fluent.withProgressDeadlineSeconds(instance.getProgressDeadlineSeconds());

            fluent.withReplicas(instance.getReplicas());

            fluent.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());

            fluent.withSelector(instance.getSelector());

            fluent.withStrategy(instance.getStrategy());

            fluent.withTemplate(instance.getTemplate());

            this.validationEnabled = validationEnabled; 
    }
    public V1beta2DeploymentSpecBuilder(V1beta2DeploymentSpec instance){
            this(instance,true);
    }
    public V1beta2DeploymentSpecBuilder(V1beta2DeploymentSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMinReadySeconds(instance.getMinReadySeconds());

            this.withPaused(instance.isPaused());

            this.withProgressDeadlineSeconds(instance.getProgressDeadlineSeconds());

            this.withReplicas(instance.getReplicas());

            this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());

            this.withSelector(instance.getSelector());

            this.withStrategy(instance.getStrategy());

            this.withTemplate(instance.getTemplate());

            this.validationEnabled = validationEnabled; 
    }

    public V1beta2DeploymentSpec build(){
            V1beta2DeploymentSpec buildable = new V1beta2DeploymentSpec();
            buildable.setMinReadySeconds(fluent.getMinReadySeconds());
            buildable.setPaused(fluent.isPaused());
            buildable.setProgressDeadlineSeconds(fluent.getProgressDeadlineSeconds());
            buildable.setReplicas(fluent.getReplicas());
            buildable.setRevisionHistoryLimit(fluent.getRevisionHistoryLimit());
            buildable.setSelector(fluent.getSelector());
            buildable.setStrategy(fluent.getStrategy());
            buildable.setTemplate(fluent.getTemplate());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta2DeploymentSpecBuilder that = (V1beta2DeploymentSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
