package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta1TokenReviewStatusBuilder extends V1beta1TokenReviewStatusFluentImpl<V1beta1TokenReviewStatusBuilder> implements VisitableBuilder<V1beta1TokenReviewStatus,V1beta1TokenReviewStatusBuilder>{

    V1beta1TokenReviewStatusFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta1TokenReviewStatusBuilder(){
            this(true);
    }
    public V1beta1TokenReviewStatusBuilder(Boolean validationEnabled){
            this(new V1beta1TokenReviewStatus(), validationEnabled);
    }
    public V1beta1TokenReviewStatusBuilder(V1beta1TokenReviewStatusFluent<?> fluent){
            this(fluent, true);
    }
    public V1beta1TokenReviewStatusBuilder(V1beta1TokenReviewStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1beta1TokenReviewStatus(), validationEnabled);
    }
    public V1beta1TokenReviewStatusBuilder(V1beta1TokenReviewStatusFluent<?> fluent,V1beta1TokenReviewStatus instance){
            this(fluent, instance, true);
    }
    public V1beta1TokenReviewStatusBuilder(V1beta1TokenReviewStatusFluent<?> fluent,V1beta1TokenReviewStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAuthenticated(instance.isAuthenticated());

            fluent.withError(instance.getError());

            fluent.withUser(instance.getUser());

            this.validationEnabled = validationEnabled; 
    }
    public V1beta1TokenReviewStatusBuilder(V1beta1TokenReviewStatus instance){
            this(instance,true);
    }
    public V1beta1TokenReviewStatusBuilder(V1beta1TokenReviewStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAuthenticated(instance.isAuthenticated());

            this.withError(instance.getError());

            this.withUser(instance.getUser());

            this.validationEnabled = validationEnabled; 
    }

    public V1beta1TokenReviewStatus build(){
            V1beta1TokenReviewStatus buildable = new V1beta1TokenReviewStatus();
            buildable.setAuthenticated(fluent.isAuthenticated());
            buildable.setError(fluent.getError());
            buildable.setUser(fluent.getUser());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta1TokenReviewStatusBuilder that = (V1beta1TokenReviewStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
