package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Deprecated;
import java.util.List;
import java.lang.Boolean;
import io.kubernetes.client.fluent.Fluent;
import java.lang.Integer;
import java.util.Collection;

public interface V1beta1StatefulSetSpecFluent<A extends V1beta1StatefulSetSpecFluent<A>> extends Fluent<A>{


    public String getPodManagementPolicy();
    public A withPodManagementPolicy(String podManagementPolicy);
    public Boolean hasPodManagementPolicy();
    public Integer getReplicas();
    public A withReplicas(Integer replicas);
    public Boolean hasReplicas();
    public A withNewReplicas(int arg1);
    public A withNewReplicas(String arg1);
    public Integer getRevisionHistoryLimit();
    public A withRevisionHistoryLimit(Integer revisionHistoryLimit);
    public Boolean hasRevisionHistoryLimit();
    public A withNewRevisionHistoryLimit(int arg1);
    public A withNewRevisionHistoryLimit(String arg1);
    
/**
 * This method has been deprecated, please use method buildSelector instead.
 * @return The buildable object.
 */
@Deprecated public V1LabelSelector getSelector();
    public V1LabelSelector buildSelector();
    public A withSelector(V1LabelSelector selector);
    public Boolean hasSelector();
    public V1beta1StatefulSetSpecFluent.SelectorNested<A> withNewSelector();
    public V1beta1StatefulSetSpecFluent.SelectorNested<A> withNewSelectorLike(V1LabelSelector item);
    public V1beta1StatefulSetSpecFluent.SelectorNested<A> editSelector();
    public V1beta1StatefulSetSpecFluent.SelectorNested<A> editOrNewSelector();
    public V1beta1StatefulSetSpecFluent.SelectorNested<A> editOrNewSelectorLike(V1LabelSelector item);
    public String getServiceName();
    public A withServiceName(String serviceName);
    public Boolean hasServiceName();
    
/**
 * This method has been deprecated, please use method buildTemplate instead.
 * @return The buildable object.
 */
@Deprecated public V1PodTemplateSpec getTemplate();
    public V1PodTemplateSpec buildTemplate();
    public A withTemplate(V1PodTemplateSpec template);
    public Boolean hasTemplate();
    public V1beta1StatefulSetSpecFluent.TemplateNested<A> withNewTemplate();
    public V1beta1StatefulSetSpecFluent.TemplateNested<A> withNewTemplateLike(V1PodTemplateSpec item);
    public V1beta1StatefulSetSpecFluent.TemplateNested<A> editTemplate();
    public V1beta1StatefulSetSpecFluent.TemplateNested<A> editOrNewTemplate();
    public V1beta1StatefulSetSpecFluent.TemplateNested<A> editOrNewTemplateLike(V1PodTemplateSpec item);
    
/**
 * This method has been deprecated, please use method buildUpdateStrategy instead.
 * @return The buildable object.
 */
@Deprecated public V1beta1StatefulSetUpdateStrategy getUpdateStrategy();
    public V1beta1StatefulSetUpdateStrategy buildUpdateStrategy();
    public A withUpdateStrategy(V1beta1StatefulSetUpdateStrategy updateStrategy);
    public Boolean hasUpdateStrategy();
    public V1beta1StatefulSetSpecFluent.UpdateStrategyNested<A> withNewUpdateStrategy();
    public V1beta1StatefulSetSpecFluent.UpdateStrategyNested<A> withNewUpdateStrategyLike(V1beta1StatefulSetUpdateStrategy item);
    public V1beta1StatefulSetSpecFluent.UpdateStrategyNested<A> editUpdateStrategy();
    public V1beta1StatefulSetSpecFluent.UpdateStrategyNested<A> editOrNewUpdateStrategy();
    public V1beta1StatefulSetSpecFluent.UpdateStrategyNested<A> editOrNewUpdateStrategyLike(V1beta1StatefulSetUpdateStrategy item);
    public A addToVolumeClaimTemplates(int index,V1PersistentVolumeClaim item);
    public A setToVolumeClaimTemplates(int index,V1PersistentVolumeClaim item);
    public A addToVolumeClaimTemplates(V1PersistentVolumeClaim... items);
    public A addAllToVolumeClaimTemplates(Collection<V1PersistentVolumeClaim> items);
    public A removeFromVolumeClaimTemplates(V1PersistentVolumeClaim... items);
    public A removeAllFromVolumeClaimTemplates(Collection<V1PersistentVolumeClaim> items);
    
/**
 * This method has been deprecated, please use method buildVolumeClaimTemplates instead.
 * @return The buildable object.
 */
@Deprecated public List<V1PersistentVolumeClaim> getVolumeClaimTemplates();
    public List<V1PersistentVolumeClaim> buildVolumeClaimTemplates();
    public V1PersistentVolumeClaim buildVolumeClaimTemplate(int index);
    public V1PersistentVolumeClaim buildFirstVolumeClaimTemplate();
    public V1PersistentVolumeClaim buildLastVolumeClaimTemplate();
    public V1PersistentVolumeClaim buildMatchingVolumeClaimTemplate(io.kubernetes.client.fluent.Predicate<V1PersistentVolumeClaimBuilder> predicate);
    public A withVolumeClaimTemplates(List<V1PersistentVolumeClaim> volumeClaimTemplates);
    public A withVolumeClaimTemplates(V1PersistentVolumeClaim... volumeClaimTemplates);
    public Boolean hasVolumeClaimTemplates();
    public V1beta1StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> addNewVolumeClaimTemplate();
    public V1beta1StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> addNewVolumeClaimTemplateLike(V1PersistentVolumeClaim item);
    public V1beta1StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> setNewVolumeClaimTemplateLike(int index,V1PersistentVolumeClaim item);
    public V1beta1StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> editVolumeClaimTemplate(int index);
    public V1beta1StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> editFirstVolumeClaimTemplate();
    public V1beta1StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> editLastVolumeClaimTemplate();
    public V1beta1StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> editMatchingVolumeClaimTemplate(io.kubernetes.client.fluent.Predicate<V1PersistentVolumeClaimBuilder> predicate);

    public interface SelectorNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1LabelSelectorFluent<V1beta1StatefulSetSpecFluent.SelectorNested<N>>{

        
    public N and();    public N endSelector();
}
    public interface TemplateNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1PodTemplateSpecFluent<V1beta1StatefulSetSpecFluent.TemplateNested<N>>{

        
    public N and();    public N endTemplate();
}
    public interface UpdateStrategyNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1beta1StatefulSetUpdateStrategyFluent<V1beta1StatefulSetSpecFluent.UpdateStrategyNested<N>>{

        
    public N and();    public N endUpdateStrategy();
}
    public interface VolumeClaimTemplatesNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1PersistentVolumeClaimFluent<V1beta1StatefulSetSpecFluent.VolumeClaimTemplatesNested<N>>{

        
    public N and();    public N endVolumeClaimTemplate();
}


}
