package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta1RoleBuilder extends V1beta1RoleFluentImpl<V1beta1RoleBuilder> implements VisitableBuilder<V1beta1Role,V1beta1RoleBuilder>{

    V1beta1RoleFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta1RoleBuilder(){
            this(true);
    }
    public V1beta1RoleBuilder(Boolean validationEnabled){
            this(new V1beta1Role(), validationEnabled);
    }
    public V1beta1RoleBuilder(V1beta1RoleFluent<?> fluent){
            this(fluent, true);
    }
    public V1beta1RoleBuilder(V1beta1RoleFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1beta1Role(), validationEnabled);
    }
    public V1beta1RoleBuilder(V1beta1RoleFluent<?> fluent,V1beta1Role instance){
            this(fluent, instance, true);
    }
    public V1beta1RoleBuilder(V1beta1RoleFluent<?> fluent,V1beta1Role instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            fluent.withRules(instance.getRules());

            this.validationEnabled = validationEnabled; 
    }
    public V1beta1RoleBuilder(V1beta1Role instance){
            this(instance,true);
    }
    public V1beta1RoleBuilder(V1beta1Role instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.withRules(instance.getRules());

            this.validationEnabled = validationEnabled; 
    }

    public V1beta1Role build(){
            V1beta1Role buildable = new V1beta1Role();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            buildable.setRules(fluent.getRules());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta1RoleBuilder that = (V1beta1RoleBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
