package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta1ReplicaSetListBuilder extends V1beta1ReplicaSetListFluentImpl<V1beta1ReplicaSetListBuilder> implements VisitableBuilder<V1beta1ReplicaSetList,V1beta1ReplicaSetListBuilder>{

    V1beta1ReplicaSetListFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta1ReplicaSetListBuilder(){
            this(true);
    }
    public V1beta1ReplicaSetListBuilder(Boolean validationEnabled){
            this(new V1beta1ReplicaSetList(), validationEnabled);
    }
    public V1beta1ReplicaSetListBuilder(V1beta1ReplicaSetListFluent<?> fluent){
            this(fluent, true);
    }
    public V1beta1ReplicaSetListBuilder(V1beta1ReplicaSetListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1beta1ReplicaSetList(), validationEnabled);
    }
    public V1beta1ReplicaSetListBuilder(V1beta1ReplicaSetListFluent<?> fluent,V1beta1ReplicaSetList instance){
            this(fluent, instance, true);
    }
    public V1beta1ReplicaSetListBuilder(V1beta1ReplicaSetListFluent<?> fluent,V1beta1ReplicaSetList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withItems(instance.getItems());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }
    public V1beta1ReplicaSetListBuilder(V1beta1ReplicaSetList instance){
            this(instance,true);
    }
    public V1beta1ReplicaSetListBuilder(V1beta1ReplicaSetList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withItems(instance.getItems());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.validationEnabled = validationEnabled; 
    }

    public V1beta1ReplicaSetList build(){
            V1beta1ReplicaSetList buildable = new V1beta1ReplicaSetList();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setItems(fluent.getItems());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta1ReplicaSetListBuilder that = (V1beta1ReplicaSetListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
