package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta1PriorityClassBuilder extends V1beta1PriorityClassFluentImpl<V1beta1PriorityClassBuilder> implements VisitableBuilder<V1beta1PriorityClass,V1beta1PriorityClassBuilder>{

    V1beta1PriorityClassFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta1PriorityClassBuilder(){
            this(true);
    }
    public V1beta1PriorityClassBuilder(Boolean validationEnabled){
            this(new V1beta1PriorityClass(), validationEnabled);
    }
    public V1beta1PriorityClassBuilder(V1beta1PriorityClassFluent<?> fluent){
            this(fluent, true);
    }
    public V1beta1PriorityClassBuilder(V1beta1PriorityClassFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1beta1PriorityClass(), validationEnabled);
    }
    public V1beta1PriorityClassBuilder(V1beta1PriorityClassFluent<?> fluent,V1beta1PriorityClass instance){
            this(fluent, instance, true);
    }
    public V1beta1PriorityClassBuilder(V1beta1PriorityClassFluent<?> fluent,V1beta1PriorityClass instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withDescription(instance.getDescription());

            fluent.withGlobalDefault(instance.isGlobalDefault());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            fluent.withValue(instance.getValue());

            this.validationEnabled = validationEnabled; 
    }
    public V1beta1PriorityClassBuilder(V1beta1PriorityClass instance){
            this(instance,true);
    }
    public V1beta1PriorityClassBuilder(V1beta1PriorityClass instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withDescription(instance.getDescription());

            this.withGlobalDefault(instance.isGlobalDefault());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.withValue(instance.getValue());

            this.validationEnabled = validationEnabled; 
    }

    public V1beta1PriorityClass build(){
            V1beta1PriorityClass buildable = new V1beta1PriorityClass();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setDescription(fluent.getDescription());
            buildable.setGlobalDefault(fluent.isGlobalDefault());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            buildable.setValue(fluent.getValue());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta1PriorityClassBuilder that = (V1beta1PriorityClassBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
