package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta1IngressTLSBuilder extends V1beta1IngressTLSFluentImpl<V1beta1IngressTLSBuilder> implements VisitableBuilder<V1beta1IngressTLS,V1beta1IngressTLSBuilder>{

    V1beta1IngressTLSFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta1IngressTLSBuilder(){
            this(true);
    }
    public V1beta1IngressTLSBuilder(Boolean validationEnabled){
            this(new V1beta1IngressTLS(), validationEnabled);
    }
    public V1beta1IngressTLSBuilder(V1beta1IngressTLSFluent<?> fluent){
            this(fluent, true);
    }
    public V1beta1IngressTLSBuilder(V1beta1IngressTLSFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1beta1IngressTLS(), validationEnabled);
    }
    public V1beta1IngressTLSBuilder(V1beta1IngressTLSFluent<?> fluent,V1beta1IngressTLS instance){
            this(fluent, instance, true);
    }
    public V1beta1IngressTLSBuilder(V1beta1IngressTLSFluent<?> fluent,V1beta1IngressTLS instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withHosts(instance.getHosts());

            fluent.withSecretName(instance.getSecretName());

            this.validationEnabled = validationEnabled; 
    }
    public V1beta1IngressTLSBuilder(V1beta1IngressTLS instance){
            this(instance,true);
    }
    public V1beta1IngressTLSBuilder(V1beta1IngressTLS instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withHosts(instance.getHosts());

            this.withSecretName(instance.getSecretName());

            this.validationEnabled = validationEnabled; 
    }

    public V1beta1IngressTLS build(){
            V1beta1IngressTLS buildable = new V1beta1IngressTLS();
            buildable.setHosts(fluent.getHosts());
            buildable.setSecretName(fluent.getSecretName());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta1IngressTLSBuilder that = (V1beta1IngressTLSBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
