package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta1IngressRuleBuilder extends V1beta1IngressRuleFluentImpl<V1beta1IngressRuleBuilder> implements VisitableBuilder<V1beta1IngressRule,V1beta1IngressRuleBuilder>{

    V1beta1IngressRuleFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta1IngressRuleBuilder(){
            this(true);
    }
    public V1beta1IngressRuleBuilder(Boolean validationEnabled){
            this(new V1beta1IngressRule(), validationEnabled);
    }
    public V1beta1IngressRuleBuilder(V1beta1IngressRuleFluent<?> fluent){
            this(fluent, true);
    }
    public V1beta1IngressRuleBuilder(V1beta1IngressRuleFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1beta1IngressRule(), validationEnabled);
    }
    public V1beta1IngressRuleBuilder(V1beta1IngressRuleFluent<?> fluent,V1beta1IngressRule instance){
            this(fluent, instance, true);
    }
    public V1beta1IngressRuleBuilder(V1beta1IngressRuleFluent<?> fluent,V1beta1IngressRule instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withHost(instance.getHost());

            fluent.withHttp(instance.getHttp());

            this.validationEnabled = validationEnabled; 
    }
    public V1beta1IngressRuleBuilder(V1beta1IngressRule instance){
            this(instance,true);
    }
    public V1beta1IngressRuleBuilder(V1beta1IngressRule instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withHost(instance.getHost());

            this.withHttp(instance.getHttp());

            this.validationEnabled = validationEnabled; 
    }

    public V1beta1IngressRule build(){
            V1beta1IngressRule buildable = new V1beta1IngressRule();
            buildable.setHost(fluent.getHost());
            buildable.setHttp(fluent.getHttp());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta1IngressRuleBuilder that = (V1beta1IngressRuleBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
