package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta1EventSeriesBuilder extends V1beta1EventSeriesFluentImpl<V1beta1EventSeriesBuilder> implements VisitableBuilder<V1beta1EventSeries,V1beta1EventSeriesBuilder>{

    V1beta1EventSeriesFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta1EventSeriesBuilder(){
            this(true);
    }
    public V1beta1EventSeriesBuilder(Boolean validationEnabled){
            this(new V1beta1EventSeries(), validationEnabled);
    }
    public V1beta1EventSeriesBuilder(V1beta1EventSeriesFluent<?> fluent){
            this(fluent, true);
    }
    public V1beta1EventSeriesBuilder(V1beta1EventSeriesFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1beta1EventSeries(), validationEnabled);
    }
    public V1beta1EventSeriesBuilder(V1beta1EventSeriesFluent<?> fluent,V1beta1EventSeries instance){
            this(fluent, instance, true);
    }
    public V1beta1EventSeriesBuilder(V1beta1EventSeriesFluent<?> fluent,V1beta1EventSeries instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withCount(instance.getCount());

            fluent.withLastObservedTime(instance.getLastObservedTime());

            fluent.withState(instance.getState());

            this.validationEnabled = validationEnabled; 
    }
    public V1beta1EventSeriesBuilder(V1beta1EventSeries instance){
            this(instance,true);
    }
    public V1beta1EventSeriesBuilder(V1beta1EventSeries instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withCount(instance.getCount());

            this.withLastObservedTime(instance.getLastObservedTime());

            this.withState(instance.getState());

            this.validationEnabled = validationEnabled; 
    }

    public V1beta1EventSeries build(){
            V1beta1EventSeries buildable = new V1beta1EventSeries();
            buildable.setCount(fluent.getCount());
            buildable.setLastObservedTime(fluent.getLastObservedTime());
            buildable.setState(fluent.getState());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta1EventSeriesBuilder that = (V1beta1EventSeriesBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
