package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta1DaemonSetSpecBuilder extends V1beta1DaemonSetSpecFluentImpl<V1beta1DaemonSetSpecBuilder> implements VisitableBuilder<V1beta1DaemonSetSpec,V1beta1DaemonSetSpecBuilder>{

    V1beta1DaemonSetSpecFluent<?> fluent;
    Boolean validationEnabled;

    public V1beta1DaemonSetSpecBuilder(){
            this(true);
    }
    public V1beta1DaemonSetSpecBuilder(Boolean validationEnabled){
            this(new V1beta1DaemonSetSpec(), validationEnabled);
    }
    public V1beta1DaemonSetSpecBuilder(V1beta1DaemonSetSpecFluent<?> fluent){
            this(fluent, true);
    }
    public V1beta1DaemonSetSpecBuilder(V1beta1DaemonSetSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1beta1DaemonSetSpec(), validationEnabled);
    }
    public V1beta1DaemonSetSpecBuilder(V1beta1DaemonSetSpecFluent<?> fluent,V1beta1DaemonSetSpec instance){
            this(fluent, instance, true);
    }
    public V1beta1DaemonSetSpecBuilder(V1beta1DaemonSetSpecFluent<?> fluent,V1beta1DaemonSetSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMinReadySeconds(instance.getMinReadySeconds());

            fluent.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());

            fluent.withSelector(instance.getSelector());

            fluent.withTemplate(instance.getTemplate());

            fluent.withTemplateGeneration(instance.getTemplateGeneration());

            fluent.withUpdateStrategy(instance.getUpdateStrategy());

            this.validationEnabled = validationEnabled; 
    }
    public V1beta1DaemonSetSpecBuilder(V1beta1DaemonSetSpec instance){
            this(instance,true);
    }
    public V1beta1DaemonSetSpecBuilder(V1beta1DaemonSetSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMinReadySeconds(instance.getMinReadySeconds());

            this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());

            this.withSelector(instance.getSelector());

            this.withTemplate(instance.getTemplate());

            this.withTemplateGeneration(instance.getTemplateGeneration());

            this.withUpdateStrategy(instance.getUpdateStrategy());

            this.validationEnabled = validationEnabled; 
    }

    public V1beta1DaemonSetSpec build(){
            V1beta1DaemonSetSpec buildable = new V1beta1DaemonSetSpec();
            buildable.setMinReadySeconds(fluent.getMinReadySeconds());
            buildable.setRevisionHistoryLimit(fluent.getRevisionHistoryLimit());
            buildable.setSelector(fluent.getSelector());
            buildable.setTemplate(fluent.getTemplate());
            buildable.setTemplateGeneration(fluent.getTemplateGeneration());
            buildable.setUpdateStrategy(fluent.getUpdateStrategy());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta1DaemonSetSpecBuilder that = (V1beta1DaemonSetSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
