package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import java.lang.Integer;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.Boolean;

public class V1beta1CronJobSpecFluentImpl<A extends V1beta1CronJobSpecFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1beta1CronJobSpecFluent<A>{

    private String concurrencyPolicy;
    private Integer failedJobsHistoryLimit;
    private V1beta1JobTemplateSpecBuilder jobTemplate;
    private String schedule;
    private Long startingDeadlineSeconds;
    private Integer successfulJobsHistoryLimit;
    private Boolean suspend;

    public V1beta1CronJobSpecFluentImpl(){
    }
    public V1beta1CronJobSpecFluentImpl(V1beta1CronJobSpec instance){
            this.withConcurrencyPolicy(instance.getConcurrencyPolicy());

            this.withFailedJobsHistoryLimit(instance.getFailedJobsHistoryLimit());

            this.withJobTemplate(instance.getJobTemplate());

            this.withSchedule(instance.getSchedule());

            this.withStartingDeadlineSeconds(instance.getStartingDeadlineSeconds());

            this.withSuccessfulJobsHistoryLimit(instance.getSuccessfulJobsHistoryLimit());

            this.withSuspend(instance.isSuspend());

    }

    public String getConcurrencyPolicy(){
            return this.concurrencyPolicy;
    }

    public A withConcurrencyPolicy(String concurrencyPolicy){
            this.concurrencyPolicy=concurrencyPolicy; return (A) this;
    }

    public Boolean hasConcurrencyPolicy(){
            return this.concurrencyPolicy != null;
    }

    public Integer getFailedJobsHistoryLimit(){
            return this.failedJobsHistoryLimit;
    }

    public A withFailedJobsHistoryLimit(Integer failedJobsHistoryLimit){
            this.failedJobsHistoryLimit=failedJobsHistoryLimit; return (A) this;
    }

    public Boolean hasFailedJobsHistoryLimit(){
            return this.failedJobsHistoryLimit != null;
    }

    public A withNewFailedJobsHistoryLimit(int arg1){
            return (A)withFailedJobsHistoryLimit(new Integer(arg1));
    }

    public A withNewFailedJobsHistoryLimit(String arg1){
            return (A)withFailedJobsHistoryLimit(new Integer(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildJobTemplate instead.
 * @return The buildable object.
 */
@Deprecated public V1beta1JobTemplateSpec getJobTemplate(){
            return this.jobTemplate!=null?this.jobTemplate.build():null;
    }

    public V1beta1JobTemplateSpec buildJobTemplate(){
            return this.jobTemplate!=null?this.jobTemplate.build():null;
    }

    public A withJobTemplate(V1beta1JobTemplateSpec jobTemplate){
            _visitables.remove(this.jobTemplate);
            if (jobTemplate!=null){ this.jobTemplate= new V1beta1JobTemplateSpecBuilder(jobTemplate); _visitables.add(this.jobTemplate);} return (A) this;
    }

    public Boolean hasJobTemplate(){
            return this.jobTemplate != null;
    }

    public V1beta1CronJobSpecFluent.JobTemplateNested<A> withNewJobTemplate(){
            return new JobTemplateNestedImpl();
    }

    public V1beta1CronJobSpecFluent.JobTemplateNested<A> withNewJobTemplateLike(V1beta1JobTemplateSpec item){
            return new JobTemplateNestedImpl(item);
    }

    public V1beta1CronJobSpecFluent.JobTemplateNested<A> editJobTemplate(){
            return withNewJobTemplateLike(getJobTemplate());
    }

    public V1beta1CronJobSpecFluent.JobTemplateNested<A> editOrNewJobTemplate(){
            return withNewJobTemplateLike(getJobTemplate() != null ? getJobTemplate(): new V1beta1JobTemplateSpecBuilder().build());
    }

    public V1beta1CronJobSpecFluent.JobTemplateNested<A> editOrNewJobTemplateLike(V1beta1JobTemplateSpec item){
            return withNewJobTemplateLike(getJobTemplate() != null ? getJobTemplate(): item);
    }

    public String getSchedule(){
            return this.schedule;
    }

    public A withSchedule(String schedule){
            this.schedule=schedule; return (A) this;
    }

    public Boolean hasSchedule(){
            return this.schedule != null;
    }

    public Long getStartingDeadlineSeconds(){
            return this.startingDeadlineSeconds;
    }

    public A withStartingDeadlineSeconds(Long startingDeadlineSeconds){
            this.startingDeadlineSeconds=startingDeadlineSeconds; return (A) this;
    }

    public Boolean hasStartingDeadlineSeconds(){
            return this.startingDeadlineSeconds != null;
    }

    public A withNewStartingDeadlineSeconds(String arg1){
            return (A)withStartingDeadlineSeconds(new Long(arg1));
    }

    public A withNewStartingDeadlineSeconds(long arg1){
            return (A)withStartingDeadlineSeconds(new Long(arg1));
    }

    public Integer getSuccessfulJobsHistoryLimit(){
            return this.successfulJobsHistoryLimit;
    }

    public A withSuccessfulJobsHistoryLimit(Integer successfulJobsHistoryLimit){
            this.successfulJobsHistoryLimit=successfulJobsHistoryLimit; return (A) this;
    }

    public Boolean hasSuccessfulJobsHistoryLimit(){
            return this.successfulJobsHistoryLimit != null;
    }

    public A withNewSuccessfulJobsHistoryLimit(int arg1){
            return (A)withSuccessfulJobsHistoryLimit(new Integer(arg1));
    }

    public A withNewSuccessfulJobsHistoryLimit(String arg1){
            return (A)withSuccessfulJobsHistoryLimit(new Integer(arg1));
    }

    public Boolean isSuspend(){
            return this.suspend;
    }

    public A withSuspend(Boolean suspend){
            this.suspend=suspend; return (A) this;
    }

    public Boolean hasSuspend(){
            return this.suspend != null;
    }

    public A withNewSuspend(boolean arg1){
            return (A)withSuspend(new Boolean(arg1));
    }

    public A withNewSuspend(String arg1){
            return (A)withSuspend(new Boolean(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1beta1CronJobSpecFluentImpl that = (V1beta1CronJobSpecFluentImpl) o;
            if (concurrencyPolicy != null ? !concurrencyPolicy.equals(that.concurrencyPolicy) :that.concurrencyPolicy != null) return false;
            if (failedJobsHistoryLimit != null ? !failedJobsHistoryLimit.equals(that.failedJobsHistoryLimit) :that.failedJobsHistoryLimit != null) return false;
            if (jobTemplate != null ? !jobTemplate.equals(that.jobTemplate) :that.jobTemplate != null) return false;
            if (schedule != null ? !schedule.equals(that.schedule) :that.schedule != null) return false;
            if (startingDeadlineSeconds != null ? !startingDeadlineSeconds.equals(that.startingDeadlineSeconds) :that.startingDeadlineSeconds != null) return false;
            if (successfulJobsHistoryLimit != null ? !successfulJobsHistoryLimit.equals(that.successfulJobsHistoryLimit) :that.successfulJobsHistoryLimit != null) return false;
            if (suspend != null ? !suspend.equals(that.suspend) :that.suspend != null) return false;
            return true;
    }


    public class JobTemplateNestedImpl<N> extends V1beta1JobTemplateSpecFluentImpl<V1beta1CronJobSpecFluent.JobTemplateNested<N>> implements V1beta1CronJobSpecFluent.JobTemplateNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1beta1JobTemplateSpecBuilder builder;
    
            JobTemplateNestedImpl(V1beta1JobTemplateSpec item){
                    this.builder = new V1beta1JobTemplateSpecBuilder(this, item);
            }
            JobTemplateNestedImpl(){
                    this.builder = new V1beta1JobTemplateSpecBuilder(this);
            }
    
    public N and(){
            return (N) V1beta1CronJobSpecFluentImpl.this.withJobTemplate(builder.build());
    }
    public N endJobTemplate(){
            return and();
    }

}


}
