package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1alpha1PodPresetSpecBuilder extends V1alpha1PodPresetSpecFluentImpl<V1alpha1PodPresetSpecBuilder> implements VisitableBuilder<V1alpha1PodPresetSpec,V1alpha1PodPresetSpecBuilder>{

    V1alpha1PodPresetSpecFluent<?> fluent;
    Boolean validationEnabled;

    public V1alpha1PodPresetSpecBuilder(){
            this(true);
    }
    public V1alpha1PodPresetSpecBuilder(Boolean validationEnabled){
            this(new V1alpha1PodPresetSpec(), validationEnabled);
    }
    public V1alpha1PodPresetSpecBuilder(V1alpha1PodPresetSpecFluent<?> fluent){
            this(fluent, true);
    }
    public V1alpha1PodPresetSpecBuilder(V1alpha1PodPresetSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1alpha1PodPresetSpec(), validationEnabled);
    }
    public V1alpha1PodPresetSpecBuilder(V1alpha1PodPresetSpecFluent<?> fluent,V1alpha1PodPresetSpec instance){
            this(fluent, instance, true);
    }
    public V1alpha1PodPresetSpecBuilder(V1alpha1PodPresetSpecFluent<?> fluent,V1alpha1PodPresetSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withEnv(instance.getEnv());

            fluent.withEnvFrom(instance.getEnvFrom());

            fluent.withSelector(instance.getSelector());

            fluent.withVolumeMounts(instance.getVolumeMounts());

            fluent.withVolumes(instance.getVolumes());

            this.validationEnabled = validationEnabled; 
    }
    public V1alpha1PodPresetSpecBuilder(V1alpha1PodPresetSpec instance){
            this(instance,true);
    }
    public V1alpha1PodPresetSpecBuilder(V1alpha1PodPresetSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withEnv(instance.getEnv());

            this.withEnvFrom(instance.getEnvFrom());

            this.withSelector(instance.getSelector());

            this.withVolumeMounts(instance.getVolumeMounts());

            this.withVolumes(instance.getVolumes());

            this.validationEnabled = validationEnabled; 
    }

    public V1alpha1PodPresetSpec build(){
            V1alpha1PodPresetSpec buildable = new V1alpha1PodPresetSpec();
            buildable.setEnv(fluent.getEnv());
            buildable.setEnvFrom(fluent.getEnvFrom());
            buildable.setSelector(fluent.getSelector());
            buildable.setVolumeMounts(fluent.getVolumeMounts());
            buildable.setVolumes(fluent.getVolumes());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1PodPresetSpecBuilder that = (V1alpha1PodPresetSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
