package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class V1alpha1InitializerConfigurationFluentImpl<A extends V1alpha1InitializerConfigurationFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1alpha1InitializerConfigurationFluent<A>{

    private String apiVersion;
    private List<V1alpha1InitializerBuilder> initializers;
    private String kind;
    private V1ObjectMetaBuilder metadata;

    public V1alpha1InitializerConfigurationFluentImpl(){
    }
    public V1alpha1InitializerConfigurationFluentImpl(V1alpha1InitializerConfiguration instance){
            this.withApiVersion(instance.getApiVersion());

            this.withInitializers(instance.getInitializers());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public A addToInitializers(int index,V1alpha1Initializer item){
            if (this.initializers == null) {this.initializers = new ArrayList<V1alpha1InitializerBuilder>();}
            V1alpha1InitializerBuilder builder = new V1alpha1InitializerBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.initializers.add(index >= 0 ? index : initializers.size(), builder); return (A)this;
    }

    public A setToInitializers(int index,V1alpha1Initializer item){
            if (this.initializers == null) {this.initializers = new ArrayList<V1alpha1InitializerBuilder>();}
            V1alpha1InitializerBuilder builder = new V1alpha1InitializerBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= initializers.size()) { initializers.add(builder); } else { initializers.set(index, builder);}
             return (A)this;
    }

    public A addToInitializers(V1alpha1Initializer... items){
            if (this.initializers == null) {this.initializers = new ArrayList<V1alpha1InitializerBuilder>();}
            for (V1alpha1Initializer item : items) {V1alpha1InitializerBuilder builder = new V1alpha1InitializerBuilder(item);_visitables.add(builder);this.initializers.add(builder);} return (A)this;
    }

    public A addAllToInitializers(Collection<V1alpha1Initializer> items){
            if (this.initializers == null) {this.initializers = new ArrayList<V1alpha1InitializerBuilder>();}
            for (V1alpha1Initializer item : items) {V1alpha1InitializerBuilder builder = new V1alpha1InitializerBuilder(item);_visitables.add(builder);this.initializers.add(builder);} return (A)this;
    }

    public A removeFromInitializers(V1alpha1Initializer... items){
            for (V1alpha1Initializer item : items) {V1alpha1InitializerBuilder builder = new V1alpha1InitializerBuilder(item);_visitables.remove(builder);if (this.initializers != null) {this.initializers.remove(builder);}} return (A)this;
    }

    public A removeAllFromInitializers(Collection<V1alpha1Initializer> items){
            for (V1alpha1Initializer item : items) {V1alpha1InitializerBuilder builder = new V1alpha1InitializerBuilder(item);_visitables.remove(builder);if (this.initializers != null) {this.initializers.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildInitializers instead.
 * @return The buildable object.
 */
@Deprecated public List<V1alpha1Initializer> getInitializers(){
            return build(initializers);
    }

    public List<V1alpha1Initializer> buildInitializers(){
            return build(initializers);
    }

    public V1alpha1Initializer buildInitializer(int index){
            return this.initializers.get(index).build();
    }

    public V1alpha1Initializer buildFirstInitializer(){
            return this.initializers.get(0).build();
    }

    public V1alpha1Initializer buildLastInitializer(){
            return this.initializers.get(initializers.size() - 1).build();
    }

    public V1alpha1Initializer buildMatchingInitializer(io.kubernetes.client.fluent.Predicate<V1alpha1InitializerBuilder> predicate){
            for (V1alpha1InitializerBuilder item: initializers) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withInitializers(List<V1alpha1Initializer> initializers){
            if (this.initializers != null) { _visitables.removeAll(this.initializers);}
            if (initializers != null) {this.initializers = new ArrayList<V1alpha1InitializerBuilder>(); for (V1alpha1Initializer item : initializers){this.addToInitializers(item);}} else { this.initializers = null;} return (A) this;
    }

    public A withInitializers(V1alpha1Initializer... initializers){
            if (this.initializers != null) {this.initializers.clear();}
            if (initializers != null) {for (V1alpha1Initializer item :initializers){ this.addToInitializers(item);}} return (A) this;
    }

    public Boolean hasInitializers(){
            return initializers != null && !initializers.isEmpty();
    }

    public V1alpha1InitializerConfigurationFluent.InitializersNested<A> addNewInitializer(){
            return new InitializersNestedImpl();
    }

    public V1alpha1InitializerConfigurationFluent.InitializersNested<A> addNewInitializerLike(V1alpha1Initializer item){
            return new InitializersNestedImpl(-1, item);
    }

    public V1alpha1InitializerConfigurationFluent.InitializersNested<A> setNewInitializerLike(int index,V1alpha1Initializer item){
            return new InitializersNestedImpl(index, item);
    }

    public V1alpha1InitializerConfigurationFluent.InitializersNested<A> editInitializer(int index){
            if (initializers.size() <= index) throw new RuntimeException("Can't edit initializers. Index exceeds size.");
            return setNewInitializerLike(index, buildInitializer(index));
    }

    public V1alpha1InitializerConfigurationFluent.InitializersNested<A> editFirstInitializer(){
            if (initializers.size() == 0) throw new RuntimeException("Can't edit first initializers. The list is empty.");
            return setNewInitializerLike(0, buildInitializer(0));
    }

    public V1alpha1InitializerConfigurationFluent.InitializersNested<A> editLastInitializer(){
            int index = initializers.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last initializers. The list is empty.");
            return setNewInitializerLike(index, buildInitializer(index));
    }

    public V1alpha1InitializerConfigurationFluent.InitializersNested<A> editMatchingInitializer(io.kubernetes.client.fluent.Predicate<V1alpha1InitializerBuilder> predicate){
            int index = -1;
            for (int i=0;i<initializers.size();i++) { 
            if (predicate.apply(initializers.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching initializers. No match found.");
            return setNewInitializerLike(index, buildInitializer(index));
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public V1ObjectMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public V1ObjectMeta buildMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(V1ObjectMeta metadata){
            _visitables.remove(this.metadata);
            if (metadata!=null){ this.metadata= new V1ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata != null;
    }

    public V1alpha1InitializerConfigurationFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public V1alpha1InitializerConfigurationFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item){
            return new MetadataNestedImpl(item);
    }

    public V1alpha1InitializerConfigurationFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public V1alpha1InitializerConfigurationFluent.MetadataNested<A> editOrNewMetadata(){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): new V1ObjectMetaBuilder().build());
    }

    public V1alpha1InitializerConfigurationFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1InitializerConfigurationFluentImpl that = (V1alpha1InitializerConfigurationFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (initializers != null ? !initializers.equals(that.initializers) :that.initializers != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            return true;
    }


    public class InitializersNestedImpl<N> extends V1alpha1InitializerFluentImpl<V1alpha1InitializerConfigurationFluent.InitializersNested<N>> implements V1alpha1InitializerConfigurationFluent.InitializersNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1alpha1InitializerBuilder builder;
        private final int index;
    
            InitializersNestedImpl(int index,V1alpha1Initializer item){
                    this.index = index;
                    this.builder = new V1alpha1InitializerBuilder(this, item);
            }
            InitializersNestedImpl(){
                    this.index = -1;
                    this.builder = new V1alpha1InitializerBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1InitializerConfigurationFluentImpl.this.setToInitializers(index, builder.build());
    }
    public N endInitializer(){
            return and();
    }

}
    public class MetadataNestedImpl<N> extends V1ObjectMetaFluentImpl<V1alpha1InitializerConfigurationFluent.MetadataNested<N>> implements V1alpha1InitializerConfigurationFluent.MetadataNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1ObjectMetaBuilder builder;
    
            MetadataNestedImpl(V1ObjectMeta item){
                    this.builder = new V1ObjectMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new V1ObjectMetaBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1InitializerConfigurationFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}


}
