package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;

public class V1alpha1ClusterRoleFluentImpl<A extends V1alpha1ClusterRoleFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1alpha1ClusterRoleFluent<A>{

    private V1alpha1AggregationRuleBuilder aggregationRule;
    private String apiVersion;
    private String kind;
    private V1ObjectMetaBuilder metadata;
    private List<V1alpha1PolicyRuleBuilder> rules;

    public V1alpha1ClusterRoleFluentImpl(){
    }
    public V1alpha1ClusterRoleFluentImpl(V1alpha1ClusterRole instance){
            this.withAggregationRule(instance.getAggregationRule());

            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.withRules(instance.getRules());

    }

    
/**
 * This method has been deprecated, please use method buildAggregationRule instead.
 * @return The buildable object.
 */
@Deprecated public V1alpha1AggregationRule getAggregationRule(){
            return this.aggregationRule!=null?this.aggregationRule.build():null;
    }

    public V1alpha1AggregationRule buildAggregationRule(){
            return this.aggregationRule!=null?this.aggregationRule.build():null;
    }

    public A withAggregationRule(V1alpha1AggregationRule aggregationRule){
            _visitables.remove(this.aggregationRule);
            if (aggregationRule!=null){ this.aggregationRule= new V1alpha1AggregationRuleBuilder(aggregationRule); _visitables.add(this.aggregationRule);} return (A) this;
    }

    public Boolean hasAggregationRule(){
            return this.aggregationRule != null;
    }

    public V1alpha1ClusterRoleFluent.AggregationRuleNested<A> withNewAggregationRule(){
            return new AggregationRuleNestedImpl();
    }

    public V1alpha1ClusterRoleFluent.AggregationRuleNested<A> withNewAggregationRuleLike(V1alpha1AggregationRule item){
            return new AggregationRuleNestedImpl(item);
    }

    public V1alpha1ClusterRoleFluent.AggregationRuleNested<A> editAggregationRule(){
            return withNewAggregationRuleLike(getAggregationRule());
    }

    public V1alpha1ClusterRoleFluent.AggregationRuleNested<A> editOrNewAggregationRule(){
            return withNewAggregationRuleLike(getAggregationRule() != null ? getAggregationRule(): new V1alpha1AggregationRuleBuilder().build());
    }

    public V1alpha1ClusterRoleFluent.AggregationRuleNested<A> editOrNewAggregationRuleLike(V1alpha1AggregationRule item){
            return withNewAggregationRuleLike(getAggregationRule() != null ? getAggregationRule(): item);
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public V1ObjectMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public V1ObjectMeta buildMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(V1ObjectMeta metadata){
            _visitables.remove(this.metadata);
            if (metadata!=null){ this.metadata= new V1ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata != null;
    }

    public V1alpha1ClusterRoleFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public V1alpha1ClusterRoleFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item){
            return new MetadataNestedImpl(item);
    }

    public V1alpha1ClusterRoleFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public V1alpha1ClusterRoleFluent.MetadataNested<A> editOrNewMetadata(){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): new V1ObjectMetaBuilder().build());
    }

    public V1alpha1ClusterRoleFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public A addToRules(int index,V1alpha1PolicyRule item){
            if (this.rules == null) {this.rules = new ArrayList<V1alpha1PolicyRuleBuilder>();}
            V1alpha1PolicyRuleBuilder builder = new V1alpha1PolicyRuleBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.rules.add(index >= 0 ? index : rules.size(), builder); return (A)this;
    }

    public A setToRules(int index,V1alpha1PolicyRule item){
            if (this.rules == null) {this.rules = new ArrayList<V1alpha1PolicyRuleBuilder>();}
            V1alpha1PolicyRuleBuilder builder = new V1alpha1PolicyRuleBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= rules.size()) { rules.add(builder); } else { rules.set(index, builder);}
             return (A)this;
    }

    public A addToRules(V1alpha1PolicyRule... items){
            if (this.rules == null) {this.rules = new ArrayList<V1alpha1PolicyRuleBuilder>();}
            for (V1alpha1PolicyRule item : items) {V1alpha1PolicyRuleBuilder builder = new V1alpha1PolicyRuleBuilder(item);_visitables.add(builder);this.rules.add(builder);} return (A)this;
    }

    public A addAllToRules(Collection<V1alpha1PolicyRule> items){
            if (this.rules == null) {this.rules = new ArrayList<V1alpha1PolicyRuleBuilder>();}
            for (V1alpha1PolicyRule item : items) {V1alpha1PolicyRuleBuilder builder = new V1alpha1PolicyRuleBuilder(item);_visitables.add(builder);this.rules.add(builder);} return (A)this;
    }

    public A removeFromRules(V1alpha1PolicyRule... items){
            for (V1alpha1PolicyRule item : items) {V1alpha1PolicyRuleBuilder builder = new V1alpha1PolicyRuleBuilder(item);_visitables.remove(builder);if (this.rules != null) {this.rules.remove(builder);}} return (A)this;
    }

    public A removeAllFromRules(Collection<V1alpha1PolicyRule> items){
            for (V1alpha1PolicyRule item : items) {V1alpha1PolicyRuleBuilder builder = new V1alpha1PolicyRuleBuilder(item);_visitables.remove(builder);if (this.rules != null) {this.rules.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildRules instead.
 * @return The buildable object.
 */
@Deprecated public List<V1alpha1PolicyRule> getRules(){
            return build(rules);
    }

    public List<V1alpha1PolicyRule> buildRules(){
            return build(rules);
    }

    public V1alpha1PolicyRule buildRule(int index){
            return this.rules.get(index).build();
    }

    public V1alpha1PolicyRule buildFirstRule(){
            return this.rules.get(0).build();
    }

    public V1alpha1PolicyRule buildLastRule(){
            return this.rules.get(rules.size() - 1).build();
    }

    public V1alpha1PolicyRule buildMatchingRule(io.kubernetes.client.fluent.Predicate<V1alpha1PolicyRuleBuilder> predicate){
            for (V1alpha1PolicyRuleBuilder item: rules) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withRules(List<V1alpha1PolicyRule> rules){
            if (this.rules != null) { _visitables.removeAll(this.rules);}
            if (rules != null) {this.rules = new ArrayList<V1alpha1PolicyRuleBuilder>(); for (V1alpha1PolicyRule item : rules){this.addToRules(item);}} else { this.rules = null;} return (A) this;
    }

    public A withRules(V1alpha1PolicyRule... rules){
            if (this.rules != null) {this.rules.clear();}
            if (rules != null) {for (V1alpha1PolicyRule item :rules){ this.addToRules(item);}} return (A) this;
    }

    public Boolean hasRules(){
            return rules != null && !rules.isEmpty();
    }

    public V1alpha1ClusterRoleFluent.RulesNested<A> addNewRule(){
            return new RulesNestedImpl();
    }

    public V1alpha1ClusterRoleFluent.RulesNested<A> addNewRuleLike(V1alpha1PolicyRule item){
            return new RulesNestedImpl(-1, item);
    }

    public V1alpha1ClusterRoleFluent.RulesNested<A> setNewRuleLike(int index,V1alpha1PolicyRule item){
            return new RulesNestedImpl(index, item);
    }

    public V1alpha1ClusterRoleFluent.RulesNested<A> editRule(int index){
            if (rules.size() <= index) throw new RuntimeException("Can't edit rules. Index exceeds size.");
            return setNewRuleLike(index, buildRule(index));
    }

    public V1alpha1ClusterRoleFluent.RulesNested<A> editFirstRule(){
            if (rules.size() == 0) throw new RuntimeException("Can't edit first rules. The list is empty.");
            return setNewRuleLike(0, buildRule(0));
    }

    public V1alpha1ClusterRoleFluent.RulesNested<A> editLastRule(){
            int index = rules.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last rules. The list is empty.");
            return setNewRuleLike(index, buildRule(index));
    }

    public V1alpha1ClusterRoleFluent.RulesNested<A> editMatchingRule(io.kubernetes.client.fluent.Predicate<V1alpha1PolicyRuleBuilder> predicate){
            int index = -1;
            for (int i=0;i<rules.size();i++) { 
            if (predicate.apply(rules.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching rules. No match found.");
            return setNewRuleLike(index, buildRule(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1alpha1ClusterRoleFluentImpl that = (V1alpha1ClusterRoleFluentImpl) o;
            if (aggregationRule != null ? !aggregationRule.equals(that.aggregationRule) :that.aggregationRule != null) return false;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            if (rules != null ? !rules.equals(that.rules) :that.rules != null) return false;
            return true;
    }


    public class AggregationRuleNestedImpl<N> extends V1alpha1AggregationRuleFluentImpl<V1alpha1ClusterRoleFluent.AggregationRuleNested<N>> implements V1alpha1ClusterRoleFluent.AggregationRuleNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1alpha1AggregationRuleBuilder builder;
    
            AggregationRuleNestedImpl(V1alpha1AggregationRule item){
                    this.builder = new V1alpha1AggregationRuleBuilder(this, item);
            }
            AggregationRuleNestedImpl(){
                    this.builder = new V1alpha1AggregationRuleBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1ClusterRoleFluentImpl.this.withAggregationRule(builder.build());
    }
    public N endAggregationRule(){
            return and();
    }

}
    public class MetadataNestedImpl<N> extends V1ObjectMetaFluentImpl<V1alpha1ClusterRoleFluent.MetadataNested<N>> implements V1alpha1ClusterRoleFluent.MetadataNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1ObjectMetaBuilder builder;
    
            MetadataNestedImpl(V1ObjectMeta item){
                    this.builder = new V1ObjectMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new V1ObjectMetaBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1ClusterRoleFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}
    public class RulesNestedImpl<N> extends V1alpha1PolicyRuleFluentImpl<V1alpha1ClusterRoleFluent.RulesNested<N>> implements V1alpha1ClusterRoleFluent.RulesNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1alpha1PolicyRuleBuilder builder;
        private final int index;
    
            RulesNestedImpl(int index,V1alpha1PolicyRule item){
                    this.index = index;
                    this.builder = new V1alpha1PolicyRuleBuilder(this, item);
            }
            RulesNestedImpl(){
                    this.index = -1;
                    this.builder = new V1alpha1PolicyRuleBuilder(this);
            }
    
    public N and(){
            return (N) V1alpha1ClusterRoleFluentImpl.this.setToRules(index, builder.build());
    }
    public N endRule(){
            return and();
    }

}


}
