package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class V1VolumeDeviceFluentImpl<A extends V1VolumeDeviceFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1VolumeDeviceFluent<A>{

    private String devicePath;
    private String name;

    public V1VolumeDeviceFluentImpl(){
    }
    public V1VolumeDeviceFluentImpl(V1VolumeDevice instance){
            this.withDevicePath(instance.getDevicePath());

            this.withName(instance.getName());

    }

    public String getDevicePath(){
            return this.devicePath;
    }

    public A withDevicePath(String devicePath){
            this.devicePath=devicePath; return (A) this;
    }

    public Boolean hasDevicePath(){
            return this.devicePath != null;
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1VolumeDeviceFluentImpl that = (V1VolumeDeviceFluentImpl) o;
            if (devicePath != null ? !devicePath.equals(that.devicePath) :that.devicePath != null) return false;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            return true;
    }




}
