package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1ServiceReferenceBuilder extends V1ServiceReferenceFluentImpl<V1ServiceReferenceBuilder> implements VisitableBuilder<V1ServiceReference,V1ServiceReferenceBuilder>{

    V1ServiceReferenceFluent<?> fluent;
    Boolean validationEnabled;

    public V1ServiceReferenceBuilder(){
            this(true);
    }
    public V1ServiceReferenceBuilder(Boolean validationEnabled){
            this(new V1ServiceReference(), validationEnabled);
    }
    public V1ServiceReferenceBuilder(V1ServiceReferenceFluent<?> fluent){
            this(fluent, true);
    }
    public V1ServiceReferenceBuilder(V1ServiceReferenceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1ServiceReference(), validationEnabled);
    }
    public V1ServiceReferenceBuilder(V1ServiceReferenceFluent<?> fluent,V1ServiceReference instance){
            this(fluent, instance, true);
    }
    public V1ServiceReferenceBuilder(V1ServiceReferenceFluent<?> fluent,V1ServiceReference instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withName(instance.getName());

            fluent.withNamespace(instance.getNamespace());

            this.validationEnabled = validationEnabled; 
    }
    public V1ServiceReferenceBuilder(V1ServiceReference instance){
            this(instance,true);
    }
    public V1ServiceReferenceBuilder(V1ServiceReference instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withName(instance.getName());

            this.withNamespace(instance.getNamespace());

            this.validationEnabled = validationEnabled; 
    }

    public V1ServiceReference build(){
            V1ServiceReference buildable = new V1ServiceReference();
            buildable.setName(fluent.getName());
            buildable.setNamespace(fluent.getNamespace());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1ServiceReferenceBuilder that = (V1ServiceReferenceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
