package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Fluent;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Deprecated;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

public interface V1ServiceAccountFluent<A extends V1ServiceAccountFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public Boolean isAutomountServiceAccountToken();
    public A withAutomountServiceAccountToken(Boolean automountServiceAccountToken);
    public Boolean hasAutomountServiceAccountToken();
    public A withNewAutomountServiceAccountToken(boolean arg1);
    public A withNewAutomountServiceAccountToken(String arg1);
    public A addToImagePullSecrets(int index,V1LocalObjectReference item);
    public A setToImagePullSecrets(int index,V1LocalObjectReference item);
    public A addToImagePullSecrets(V1LocalObjectReference... items);
    public A addAllToImagePullSecrets(Collection<V1LocalObjectReference> items);
    public A removeFromImagePullSecrets(V1LocalObjectReference... items);
    public A removeAllFromImagePullSecrets(Collection<V1LocalObjectReference> items);
    
/**
 * This method has been deprecated, please use method buildImagePullSecrets instead.
 * @return The buildable object.
 */
@Deprecated public List<V1LocalObjectReference> getImagePullSecrets();
    public List<V1LocalObjectReference> buildImagePullSecrets();
    public V1LocalObjectReference buildImagePullSecret(int index);
    public V1LocalObjectReference buildFirstImagePullSecret();
    public V1LocalObjectReference buildLastImagePullSecret();
    public V1LocalObjectReference buildMatchingImagePullSecret(io.kubernetes.client.fluent.Predicate<V1LocalObjectReferenceBuilder> predicate);
    public A withImagePullSecrets(List<V1LocalObjectReference> imagePullSecrets);
    public A withImagePullSecrets(V1LocalObjectReference... imagePullSecrets);
    public Boolean hasImagePullSecrets();
    public V1ServiceAccountFluent.ImagePullSecretsNested<A> addNewImagePullSecret();
    public V1ServiceAccountFluent.ImagePullSecretsNested<A> addNewImagePullSecretLike(V1LocalObjectReference item);
    public V1ServiceAccountFluent.ImagePullSecretsNested<A> setNewImagePullSecretLike(int index,V1LocalObjectReference item);
    public V1ServiceAccountFluent.ImagePullSecretsNested<A> editImagePullSecret(int index);
    public V1ServiceAccountFluent.ImagePullSecretsNested<A> editFirstImagePullSecret();
    public V1ServiceAccountFluent.ImagePullSecretsNested<A> editLastImagePullSecret();
    public V1ServiceAccountFluent.ImagePullSecretsNested<A> editMatchingImagePullSecret(io.kubernetes.client.fluent.Predicate<V1LocalObjectReferenceBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public V1ObjectMeta getMetadata();
    public V1ObjectMeta buildMetadata();
    public A withMetadata(V1ObjectMeta metadata);
    public Boolean hasMetadata();
    public V1ServiceAccountFluent.MetadataNested<A> withNewMetadata();
    public V1ServiceAccountFluent.MetadataNested<A> withNewMetadataLike(V1ObjectMeta item);
    public V1ServiceAccountFluent.MetadataNested<A> editMetadata();
    public V1ServiceAccountFluent.MetadataNested<A> editOrNewMetadata();
    public V1ServiceAccountFluent.MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item);
    public A addToSecrets(int index,V1ObjectReference item);
    public A setToSecrets(int index,V1ObjectReference item);
    public A addToSecrets(V1ObjectReference... items);
    public A addAllToSecrets(Collection<V1ObjectReference> items);
    public A removeFromSecrets(V1ObjectReference... items);
    public A removeAllFromSecrets(Collection<V1ObjectReference> items);
    
/**
 * This method has been deprecated, please use method buildSecrets instead.
 * @return The buildable object.
 */
@Deprecated public List<V1ObjectReference> getSecrets();
    public List<V1ObjectReference> buildSecrets();
    public V1ObjectReference buildSecret(int index);
    public V1ObjectReference buildFirstSecret();
    public V1ObjectReference buildLastSecret();
    public V1ObjectReference buildMatchingSecret(io.kubernetes.client.fluent.Predicate<V1ObjectReferenceBuilder> predicate);
    public A withSecrets(List<V1ObjectReference> secrets);
    public A withSecrets(V1ObjectReference... secrets);
    public Boolean hasSecrets();
    public V1ServiceAccountFluent.SecretsNested<A> addNewSecret();
    public V1ServiceAccountFluent.SecretsNested<A> addNewSecretLike(V1ObjectReference item);
    public V1ServiceAccountFluent.SecretsNested<A> setNewSecretLike(int index,V1ObjectReference item);
    public V1ServiceAccountFluent.SecretsNested<A> editSecret(int index);
    public V1ServiceAccountFluent.SecretsNested<A> editFirstSecret();
    public V1ServiceAccountFluent.SecretsNested<A> editLastSecret();
    public V1ServiceAccountFluent.SecretsNested<A> editMatchingSecret(io.kubernetes.client.fluent.Predicate<V1ObjectReferenceBuilder> predicate);

    public interface ImagePullSecretsNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1LocalObjectReferenceFluent<V1ServiceAccountFluent.ImagePullSecretsNested<N>>{

        
    public N and();    public N endImagePullSecret();
}
    public interface MetadataNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1ObjectMetaFluent<V1ServiceAccountFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SecretsNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1ObjectReferenceFluent<V1ServiceAccountFluent.SecretsNested<N>>{

        
    public N and();    public N endSecret();
}


}
