package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Fluent;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import java.lang.String;
import org.joda.time.DateTime;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Deprecated;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public interface V1PodStatusFluent<A extends V1PodStatusFluent<A>> extends Fluent<A>{


    public A addToConditions(int index,V1PodCondition item);
    public A setToConditions(int index,V1PodCondition item);
    public A addToConditions(V1PodCondition... items);
    public A addAllToConditions(Collection<V1PodCondition> items);
    public A removeFromConditions(V1PodCondition... items);
    public A removeAllFromConditions(Collection<V1PodCondition> items);
    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<V1PodCondition> getConditions();
    public List<V1PodCondition> buildConditions();
    public V1PodCondition buildCondition(int index);
    public V1PodCondition buildFirstCondition();
    public V1PodCondition buildLastCondition();
    public V1PodCondition buildMatchingCondition(io.kubernetes.client.fluent.Predicate<V1PodConditionBuilder> predicate);
    public A withConditions(List<V1PodCondition> conditions);
    public A withConditions(V1PodCondition... conditions);
    public Boolean hasConditions();
    public V1PodStatusFluent.ConditionsNested<A> addNewCondition();
    public V1PodStatusFluent.ConditionsNested<A> addNewConditionLike(V1PodCondition item);
    public V1PodStatusFluent.ConditionsNested<A> setNewConditionLike(int index,V1PodCondition item);
    public V1PodStatusFluent.ConditionsNested<A> editCondition(int index);
    public V1PodStatusFluent.ConditionsNested<A> editFirstCondition();
    public V1PodStatusFluent.ConditionsNested<A> editLastCondition();
    public V1PodStatusFluent.ConditionsNested<A> editMatchingCondition(io.kubernetes.client.fluent.Predicate<V1PodConditionBuilder> predicate);
    public A addToContainerStatuses(int index,V1ContainerStatus item);
    public A setToContainerStatuses(int index,V1ContainerStatus item);
    public A addToContainerStatuses(V1ContainerStatus... items);
    public A addAllToContainerStatuses(Collection<V1ContainerStatus> items);
    public A removeFromContainerStatuses(V1ContainerStatus... items);
    public A removeAllFromContainerStatuses(Collection<V1ContainerStatus> items);
    
/**
 * This method has been deprecated, please use method buildContainerStatuses instead.
 * @return The buildable object.
 */
@Deprecated public List<V1ContainerStatus> getContainerStatuses();
    public List<V1ContainerStatus> buildContainerStatuses();
    public V1ContainerStatus buildContainerStatus(int index);
    public V1ContainerStatus buildFirstContainerStatus();
    public V1ContainerStatus buildLastContainerStatus();
    public V1ContainerStatus buildMatchingContainerStatus(io.kubernetes.client.fluent.Predicate<V1ContainerStatusBuilder> predicate);
    public A withContainerStatuses(List<V1ContainerStatus> containerStatuses);
    public A withContainerStatuses(V1ContainerStatus... containerStatuses);
    public Boolean hasContainerStatuses();
    public V1PodStatusFluent.ContainerStatusesNested<A> addNewContainerStatus();
    public V1PodStatusFluent.ContainerStatusesNested<A> addNewContainerStatusLike(V1ContainerStatus item);
    public V1PodStatusFluent.ContainerStatusesNested<A> setNewContainerStatusLike(int index,V1ContainerStatus item);
    public V1PodStatusFluent.ContainerStatusesNested<A> editContainerStatus(int index);
    public V1PodStatusFluent.ContainerStatusesNested<A> editFirstContainerStatus();
    public V1PodStatusFluent.ContainerStatusesNested<A> editLastContainerStatus();
    public V1PodStatusFluent.ContainerStatusesNested<A> editMatchingContainerStatus(io.kubernetes.client.fluent.Predicate<V1ContainerStatusBuilder> predicate);
    public String getHostIP();
    public A withHostIP(String hostIP);
    public Boolean hasHostIP();
    public A addToInitContainerStatuses(int index,V1ContainerStatus item);
    public A setToInitContainerStatuses(int index,V1ContainerStatus item);
    public A addToInitContainerStatuses(V1ContainerStatus... items);
    public A addAllToInitContainerStatuses(Collection<V1ContainerStatus> items);
    public A removeFromInitContainerStatuses(V1ContainerStatus... items);
    public A removeAllFromInitContainerStatuses(Collection<V1ContainerStatus> items);
    
/**
 * This method has been deprecated, please use method buildInitContainerStatuses instead.
 * @return The buildable object.
 */
@Deprecated public List<V1ContainerStatus> getInitContainerStatuses();
    public List<V1ContainerStatus> buildInitContainerStatuses();
    public V1ContainerStatus buildInitContainerStatus(int index);
    public V1ContainerStatus buildFirstInitContainerStatus();
    public V1ContainerStatus buildLastInitContainerStatus();
    public V1ContainerStatus buildMatchingInitContainerStatus(io.kubernetes.client.fluent.Predicate<V1ContainerStatusBuilder> predicate);
    public A withInitContainerStatuses(List<V1ContainerStatus> initContainerStatuses);
    public A withInitContainerStatuses(V1ContainerStatus... initContainerStatuses);
    public Boolean hasInitContainerStatuses();
    public V1PodStatusFluent.InitContainerStatusesNested<A> addNewInitContainerStatus();
    public V1PodStatusFluent.InitContainerStatusesNested<A> addNewInitContainerStatusLike(V1ContainerStatus item);
    public V1PodStatusFluent.InitContainerStatusesNested<A> setNewInitContainerStatusLike(int index,V1ContainerStatus item);
    public V1PodStatusFluent.InitContainerStatusesNested<A> editInitContainerStatus(int index);
    public V1PodStatusFluent.InitContainerStatusesNested<A> editFirstInitContainerStatus();
    public V1PodStatusFluent.InitContainerStatusesNested<A> editLastInitContainerStatus();
    public V1PodStatusFluent.InitContainerStatusesNested<A> editMatchingInitContainerStatus(io.kubernetes.client.fluent.Predicate<V1ContainerStatusBuilder> predicate);
    public String getMessage();
    public A withMessage(String message);
    public Boolean hasMessage();
    public String getNominatedNodeName();
    public A withNominatedNodeName(String nominatedNodeName);
    public Boolean hasNominatedNodeName();
    public String getPhase();
    public A withPhase(String phase);
    public Boolean hasPhase();
    public String getPodIP();
    public A withPodIP(String podIP);
    public Boolean hasPodIP();
    public String getQosClass();
    public A withQosClass(String qosClass);
    public Boolean hasQosClass();
    public String getReason();
    public A withReason(String reason);
    public Boolean hasReason();
    public DateTime getStartTime();
    public A withStartTime(DateTime startTime);
    public Boolean hasStartTime();
    public A withNewStartTime(int arg0,int arg1,int arg2,int arg3,int arg4);
    public A withNewStartTime(long arg0);
    public A withNewStartTime(Object arg0);

    public interface ConditionsNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1PodConditionFluent<V1PodStatusFluent.ConditionsNested<N>>{

        
    public N and();    public N endCondition();
}
    public interface ContainerStatusesNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1ContainerStatusFluent<V1PodStatusFluent.ContainerStatusesNested<N>>{

        
    public N and();    public N endContainerStatus();
}
    public interface InitContainerStatusesNested<N> extends io.kubernetes.client.fluent.Nested<N>,V1ContainerStatusFluent<V1PodStatusFluent.InitContainerStatusesNested<N>>{

        
    public N and();    public N endInitContainerStatus();
}


}
