package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.lang.Boolean;
import io.kubernetes.client.fluent.Predicate;

public class V1NonResourceRuleFluentImpl<A extends V1NonResourceRuleFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1NonResourceRuleFluent<A>{

    private List<String> nonResourceURLs;
    private List<String> verbs;

    public V1NonResourceRuleFluentImpl(){
    }
    public V1NonResourceRuleFluentImpl(V1NonResourceRule instance){
            this.withNonResourceURLs(instance.getNonResourceURLs());

            this.withVerbs(instance.getVerbs());

    }

    public A addToNonResourceURLs(int index,String item){
            if (this.nonResourceURLs == null) {this.nonResourceURLs = new ArrayList<String>();}
            this.nonResourceURLs.add(index, item);
            return (A)this;
    }

    public A setToNonResourceURLs(int index,String item){
            if (this.nonResourceURLs == null) {this.nonResourceURLs = new ArrayList<String>();}
            this.nonResourceURLs.set(index, item); return (A)this;
    }

    public A addToNonResourceURLs(String... items){
            if (this.nonResourceURLs == null) {this.nonResourceURLs = new ArrayList<String>();}
            for (String item : items) {this.nonResourceURLs.add(item);} return (A)this;
    }

    public A addAllToNonResourceURLs(Collection<String> items){
            if (this.nonResourceURLs == null) {this.nonResourceURLs = new ArrayList<String>();}
            for (String item : items) {this.nonResourceURLs.add(item);} return (A)this;
    }

    public A removeFromNonResourceURLs(String... items){
            for (String item : items) {if (this.nonResourceURLs!= null){ this.nonResourceURLs.remove(item);}} return (A)this;
    }

    public A removeAllFromNonResourceURLs(Collection<String> items){
            for (String item : items) {if (this.nonResourceURLs!= null){ this.nonResourceURLs.remove(item);}} return (A)this;
    }

    public List<String> getNonResourceURLs(){
            return this.nonResourceURLs;
    }

    public String getNonResourceURL(int index){
            return this.nonResourceURLs.get(index);
    }

    public String getFirstNonResourceURL(){
            return this.nonResourceURLs.get(0);
    }

    public String getLastNonResourceURL(){
            return this.nonResourceURLs.get(nonResourceURLs.size() - 1);
    }

    public String getMatchingNonResourceURL(io.kubernetes.client.fluent.Predicate<String> predicate){
            for (String item: nonResourceURLs) { if(predicate.apply(item)){return item;} } return null;
    }

    public A withNonResourceURLs(List<String> nonResourceURLs){
            if (this.nonResourceURLs != null) { _visitables.removeAll(this.nonResourceURLs);}
            if (nonResourceURLs != null) {this.nonResourceURLs = new ArrayList<String>(); for (String item : nonResourceURLs){this.addToNonResourceURLs(item);}} else { this.nonResourceURLs = null;} return (A) this;
    }

    public A withNonResourceURLs(String... nonResourceURLs){
            if (this.nonResourceURLs != null) {this.nonResourceURLs.clear();}
            if (nonResourceURLs != null) {for (String item :nonResourceURLs){ this.addToNonResourceURLs(item);}} return (A) this;
    }

    public Boolean hasNonResourceURLs(){
            return nonResourceURLs != null && !nonResourceURLs.isEmpty();
    }

    public A addToVerbs(int index,String item){
            if (this.verbs == null) {this.verbs = new ArrayList<String>();}
            this.verbs.add(index, item);
            return (A)this;
    }

    public A setToVerbs(int index,String item){
            if (this.verbs == null) {this.verbs = new ArrayList<String>();}
            this.verbs.set(index, item); return (A)this;
    }

    public A addToVerbs(String... items){
            if (this.verbs == null) {this.verbs = new ArrayList<String>();}
            for (String item : items) {this.verbs.add(item);} return (A)this;
    }

    public A addAllToVerbs(Collection<String> items){
            if (this.verbs == null) {this.verbs = new ArrayList<String>();}
            for (String item : items) {this.verbs.add(item);} return (A)this;
    }

    public A removeFromVerbs(String... items){
            for (String item : items) {if (this.verbs!= null){ this.verbs.remove(item);}} return (A)this;
    }

    public A removeAllFromVerbs(Collection<String> items){
            for (String item : items) {if (this.verbs!= null){ this.verbs.remove(item);}} return (A)this;
    }

    public List<String> getVerbs(){
            return this.verbs;
    }

    public String getVerb(int index){
            return this.verbs.get(index);
    }

    public String getFirstVerb(){
            return this.verbs.get(0);
    }

    public String getLastVerb(){
            return this.verbs.get(verbs.size() - 1);
    }

    public String getMatchingVerb(io.kubernetes.client.fluent.Predicate<String> predicate){
            for (String item: verbs) { if(predicate.apply(item)){return item;} } return null;
    }

    public A withVerbs(List<String> verbs){
            if (this.verbs != null) { _visitables.removeAll(this.verbs);}
            if (verbs != null) {this.verbs = new ArrayList<String>(); for (String item : verbs){this.addToVerbs(item);}} else { this.verbs = null;} return (A) this;
    }

    public A withVerbs(String... verbs){
            if (this.verbs != null) {this.verbs.clear();}
            if (verbs != null) {for (String item :verbs){ this.addToVerbs(item);}} return (A) this;
    }

    public Boolean hasVerbs(){
            return verbs != null && !verbs.isEmpty();
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1NonResourceRuleFluentImpl that = (V1NonResourceRuleFluentImpl) o;
            if (nonResourceURLs != null ? !nonResourceURLs.equals(that.nonResourceURLs) :that.nonResourceURLs != null) return false;
            if (verbs != null ? !verbs.equals(that.verbs) :that.verbs != null) return false;
            return true;
    }




}
