package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.util.ArrayList;
import io.kubernetes.client.fluent.Predicate;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class V1InitializersFluentImpl<A extends V1InitializersFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1InitializersFluent<A>{

    private List<V1InitializerBuilder> pending;
    private V1StatusBuilder result;

    public V1InitializersFluentImpl(){
    }
    public V1InitializersFluentImpl(V1Initializers instance){
            this.withPending(instance.getPending());

            this.withResult(instance.getResult());

    }

    public A addToPending(int index,V1Initializer item){
            if (this.pending == null) {this.pending = new ArrayList<V1InitializerBuilder>();}
            V1InitializerBuilder builder = new V1InitializerBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.pending.add(index >= 0 ? index : pending.size(), builder); return (A)this;
    }

    public A setToPending(int index,V1Initializer item){
            if (this.pending == null) {this.pending = new ArrayList<V1InitializerBuilder>();}
            V1InitializerBuilder builder = new V1InitializerBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= pending.size()) { pending.add(builder); } else { pending.set(index, builder);}
             return (A)this;
    }

    public A addToPending(V1Initializer... items){
            if (this.pending == null) {this.pending = new ArrayList<V1InitializerBuilder>();}
            for (V1Initializer item : items) {V1InitializerBuilder builder = new V1InitializerBuilder(item);_visitables.add(builder);this.pending.add(builder);} return (A)this;
    }

    public A addAllToPending(Collection<V1Initializer> items){
            if (this.pending == null) {this.pending = new ArrayList<V1InitializerBuilder>();}
            for (V1Initializer item : items) {V1InitializerBuilder builder = new V1InitializerBuilder(item);_visitables.add(builder);this.pending.add(builder);} return (A)this;
    }

    public A removeFromPending(V1Initializer... items){
            for (V1Initializer item : items) {V1InitializerBuilder builder = new V1InitializerBuilder(item);_visitables.remove(builder);if (this.pending != null) {this.pending.remove(builder);}} return (A)this;
    }

    public A removeAllFromPending(Collection<V1Initializer> items){
            for (V1Initializer item : items) {V1InitializerBuilder builder = new V1InitializerBuilder(item);_visitables.remove(builder);if (this.pending != null) {this.pending.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildPending instead.
 * @return The buildable object.
 */
@Deprecated public List<V1Initializer> getPending(){
            return build(pending);
    }

    public List<V1Initializer> buildPending(){
            return build(pending);
    }

    public V1Initializer buildPending(int index){
            return this.pending.get(index).build();
    }

    public V1Initializer buildFirstPending(){
            return this.pending.get(0).build();
    }

    public V1Initializer buildLastPending(){
            return this.pending.get(pending.size() - 1).build();
    }

    public V1Initializer buildMatchingPending(io.kubernetes.client.fluent.Predicate<V1InitializerBuilder> predicate){
            for (V1InitializerBuilder item: pending) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withPending(List<V1Initializer> pending){
            if (this.pending != null) { _visitables.removeAll(this.pending);}
            if (pending != null) {this.pending = new ArrayList<V1InitializerBuilder>(); for (V1Initializer item : pending){this.addToPending(item);}} else { this.pending = null;} return (A) this;
    }

    public A withPending(V1Initializer... pending){
            if (this.pending != null) {this.pending.clear();}
            if (pending != null) {for (V1Initializer item :pending){ this.addToPending(item);}} return (A) this;
    }

    public Boolean hasPending(){
            return pending != null && !pending.isEmpty();
    }

    public V1InitializersFluent.PendingNested<A> addNewPending(){
            return new PendingNestedImpl();
    }

    public V1InitializersFluent.PendingNested<A> addNewPendingLike(V1Initializer item){
            return new PendingNestedImpl(-1, item);
    }

    public V1InitializersFluent.PendingNested<A> setNewPendingLike(int index,V1Initializer item){
            return new PendingNestedImpl(index, item);
    }

    public V1InitializersFluent.PendingNested<A> editPending(int index){
            if (pending.size() <= index) throw new RuntimeException("Can't edit pending. Index exceeds size.");
            return setNewPendingLike(index, buildPending(index));
    }

    public V1InitializersFluent.PendingNested<A> editFirstPending(){
            if (pending.size() == 0) throw new RuntimeException("Can't edit first pending. The list is empty.");
            return setNewPendingLike(0, buildPending(0));
    }

    public V1InitializersFluent.PendingNested<A> editLastPending(){
            int index = pending.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last pending. The list is empty.");
            return setNewPendingLike(index, buildPending(index));
    }

    public V1InitializersFluent.PendingNested<A> editMatchingPending(io.kubernetes.client.fluent.Predicate<V1InitializerBuilder> predicate){
            int index = -1;
            for (int i=0;i<pending.size();i++) { 
            if (predicate.apply(pending.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching pending. No match found.");
            return setNewPendingLike(index, buildPending(index));
    }

    
/**
 * This method has been deprecated, please use method buildResult instead.
 * @return The buildable object.
 */
@Deprecated public V1Status getResult(){
            return this.result!=null?this.result.build():null;
    }

    public V1Status buildResult(){
            return this.result!=null?this.result.build():null;
    }

    public A withResult(V1Status result){
            _visitables.remove(this.result);
            if (result!=null){ this.result= new V1StatusBuilder(result); _visitables.add(this.result);} return (A) this;
    }

    public Boolean hasResult(){
            return this.result != null;
    }

    public V1InitializersFluent.ResultNested<A> withNewResult(){
            return new ResultNestedImpl();
    }

    public V1InitializersFluent.ResultNested<A> withNewResultLike(V1Status item){
            return new ResultNestedImpl(item);
    }

    public V1InitializersFluent.ResultNested<A> editResult(){
            return withNewResultLike(getResult());
    }

    public V1InitializersFluent.ResultNested<A> editOrNewResult(){
            return withNewResultLike(getResult() != null ? getResult(): new V1StatusBuilder().build());
    }

    public V1InitializersFluent.ResultNested<A> editOrNewResultLike(V1Status item){
            return withNewResultLike(getResult() != null ? getResult(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1InitializersFluentImpl that = (V1InitializersFluentImpl) o;
            if (pending != null ? !pending.equals(that.pending) :that.pending != null) return false;
            if (result != null ? !result.equals(that.result) :that.result != null) return false;
            return true;
    }


    public class PendingNestedImpl<N> extends V1InitializerFluentImpl<V1InitializersFluent.PendingNested<N>> implements V1InitializersFluent.PendingNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1InitializerBuilder builder;
        private final int index;
    
            PendingNestedImpl(int index,V1Initializer item){
                    this.index = index;
                    this.builder = new V1InitializerBuilder(this, item);
            }
            PendingNestedImpl(){
                    this.index = -1;
                    this.builder = new V1InitializerBuilder(this);
            }
    
    public N and(){
            return (N) V1InitializersFluentImpl.this.setToPending(index, builder.build());
    }
    public N endPending(){
            return and();
    }

}
    public class ResultNestedImpl<N> extends V1StatusFluentImpl<V1InitializersFluent.ResultNested<N>> implements V1InitializersFluent.ResultNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1StatusBuilder builder;
    
            ResultNestedImpl(V1Status item){
                    this.builder = new V1StatusBuilder(this, item);
            }
            ResultNestedImpl(){
                    this.builder = new V1StatusBuilder(this);
            }
    
    public N and(){
            return (N) V1InitializersFluentImpl.this.withResult(builder.build());
    }
    public N endResult(){
            return and();
    }

}


}
