package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class V1ISCSIPersistentVolumeSourceBuilder extends V1ISCSIPersistentVolumeSourceFluentImpl<V1ISCSIPersistentVolumeSourceBuilder> implements VisitableBuilder<V1ISCSIPersistentVolumeSource,V1ISCSIPersistentVolumeSourceBuilder>{

    V1ISCSIPersistentVolumeSourceFluent<?> fluent;
    Boolean validationEnabled;

    public V1ISCSIPersistentVolumeSourceBuilder(){
            this(true);
    }
    public V1ISCSIPersistentVolumeSourceBuilder(Boolean validationEnabled){
            this(new V1ISCSIPersistentVolumeSource(), validationEnabled);
    }
    public V1ISCSIPersistentVolumeSourceBuilder(V1ISCSIPersistentVolumeSourceFluent<?> fluent){
            this(fluent, true);
    }
    public V1ISCSIPersistentVolumeSourceBuilder(V1ISCSIPersistentVolumeSourceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new V1ISCSIPersistentVolumeSource(), validationEnabled);
    }
    public V1ISCSIPersistentVolumeSourceBuilder(V1ISCSIPersistentVolumeSourceFluent<?> fluent,V1ISCSIPersistentVolumeSource instance){
            this(fluent, instance, true);
    }
    public V1ISCSIPersistentVolumeSourceBuilder(V1ISCSIPersistentVolumeSourceFluent<?> fluent,V1ISCSIPersistentVolumeSource instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withChapAuthDiscovery(instance.isChapAuthDiscovery());

            fluent.withChapAuthSession(instance.isChapAuthSession());

            fluent.withFsType(instance.getFsType());

            fluent.withInitiatorName(instance.getInitiatorName());

            fluent.withIqn(instance.getIqn());

            fluent.withIscsiInterface(instance.getIscsiInterface());

            fluent.withLun(instance.getLun());

            fluent.withPortals(instance.getPortals());

            fluent.withReadOnly(instance.isReadOnly());

            fluent.withSecretRef(instance.getSecretRef());

            fluent.withTargetPortal(instance.getTargetPortal());

            this.validationEnabled = validationEnabled; 
    }
    public V1ISCSIPersistentVolumeSourceBuilder(V1ISCSIPersistentVolumeSource instance){
            this(instance,true);
    }
    public V1ISCSIPersistentVolumeSourceBuilder(V1ISCSIPersistentVolumeSource instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withChapAuthDiscovery(instance.isChapAuthDiscovery());

            this.withChapAuthSession(instance.isChapAuthSession());

            this.withFsType(instance.getFsType());

            this.withInitiatorName(instance.getInitiatorName());

            this.withIqn(instance.getIqn());

            this.withIscsiInterface(instance.getIscsiInterface());

            this.withLun(instance.getLun());

            this.withPortals(instance.getPortals());

            this.withReadOnly(instance.isReadOnly());

            this.withSecretRef(instance.getSecretRef());

            this.withTargetPortal(instance.getTargetPortal());

            this.validationEnabled = validationEnabled; 
    }

    public V1ISCSIPersistentVolumeSource build(){
            V1ISCSIPersistentVolumeSource buildable = new V1ISCSIPersistentVolumeSource();
            buildable.setChapAuthDiscovery(fluent.isChapAuthDiscovery());
            buildable.setChapAuthSession(fluent.isChapAuthSession());
            buildable.setFsType(fluent.getFsType());
            buildable.setInitiatorName(fluent.getInitiatorName());
            buildable.setIqn(fluent.getIqn());
            buildable.setIscsiInterface(fluent.getIscsiInterface());
            buildable.setLun(fluent.getLun());
            buildable.setPortals(fluent.getPortals());
            buildable.setReadOnly(fluent.isReadOnly());
            buildable.setSecretRef(fluent.getSecretRef());
            buildable.setTargetPortal(fluent.getTargetPortal());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1ISCSIPersistentVolumeSourceBuilder that = (V1ISCSIPersistentVolumeSourceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
