package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class V1DeploymentStrategyFluentImpl<A extends V1DeploymentStrategyFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1DeploymentStrategyFluent<A>{

    private V1RollingUpdateDeploymentBuilder rollingUpdate;
    private String type;

    public V1DeploymentStrategyFluentImpl(){
    }
    public V1DeploymentStrategyFluentImpl(V1DeploymentStrategy instance){
            this.withRollingUpdate(instance.getRollingUpdate());

            this.withType(instance.getType());

    }

    
/**
 * This method has been deprecated, please use method buildRollingUpdate instead.
 * @return The buildable object.
 */
@Deprecated public V1RollingUpdateDeployment getRollingUpdate(){
            return this.rollingUpdate!=null?this.rollingUpdate.build():null;
    }

    public V1RollingUpdateDeployment buildRollingUpdate(){
            return this.rollingUpdate!=null?this.rollingUpdate.build():null;
    }

    public A withRollingUpdate(V1RollingUpdateDeployment rollingUpdate){
            _visitables.remove(this.rollingUpdate);
            if (rollingUpdate!=null){ this.rollingUpdate= new V1RollingUpdateDeploymentBuilder(rollingUpdate); _visitables.add(this.rollingUpdate);} return (A) this;
    }

    public Boolean hasRollingUpdate(){
            return this.rollingUpdate != null;
    }

    public V1DeploymentStrategyFluent.RollingUpdateNested<A> withNewRollingUpdate(){
            return new RollingUpdateNestedImpl();
    }

    public V1DeploymentStrategyFluent.RollingUpdateNested<A> withNewRollingUpdateLike(V1RollingUpdateDeployment item){
            return new RollingUpdateNestedImpl(item);
    }

    public V1DeploymentStrategyFluent.RollingUpdateNested<A> editRollingUpdate(){
            return withNewRollingUpdateLike(getRollingUpdate());
    }

    public V1DeploymentStrategyFluent.RollingUpdateNested<A> editOrNewRollingUpdate(){
            return withNewRollingUpdateLike(getRollingUpdate() != null ? getRollingUpdate(): new V1RollingUpdateDeploymentBuilder().build());
    }

    public V1DeploymentStrategyFluent.RollingUpdateNested<A> editOrNewRollingUpdateLike(V1RollingUpdateDeployment item){
            return withNewRollingUpdateLike(getRollingUpdate() != null ? getRollingUpdate(): item);
    }

    public String getType(){
            return this.type;
    }

    public A withType(String type){
            this.type=type; return (A) this;
    }

    public Boolean hasType(){
            return this.type != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1DeploymentStrategyFluentImpl that = (V1DeploymentStrategyFluentImpl) o;
            if (rollingUpdate != null ? !rollingUpdate.equals(that.rollingUpdate) :that.rollingUpdate != null) return false;
            if (type != null ? !type.equals(that.type) :that.type != null) return false;
            return true;
    }


    public class RollingUpdateNestedImpl<N> extends V1RollingUpdateDeploymentFluentImpl<V1DeploymentStrategyFluent.RollingUpdateNested<N>> implements V1DeploymentStrategyFluent.RollingUpdateNested<N>,io.kubernetes.client.fluent.Nested<N>{

            private final V1RollingUpdateDeploymentBuilder builder;
    
            RollingUpdateNestedImpl(V1RollingUpdateDeployment item){
                    this.builder = new V1RollingUpdateDeploymentBuilder(this, item);
            }
            RollingUpdateNestedImpl(){
                    this.builder = new V1RollingUpdateDeploymentBuilder(this);
            }
    
    public N and(){
            return (N) V1DeploymentStrategyFluentImpl.this.withRollingUpdate(builder.build());
    }
    public N endRollingUpdate(){
            return and();
    }

}


}
