package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.fluent.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class V1AzureFileVolumeSourceFluentImpl<A extends V1AzureFileVolumeSourceFluent<A>> extends io.kubernetes.client.fluent.BaseFluent<A> implements V1AzureFileVolumeSourceFluent<A>{

    private Boolean readOnly;
    private String secretName;
    private String shareName;

    public V1AzureFileVolumeSourceFluentImpl(){
    }
    public V1AzureFileVolumeSourceFluentImpl(V1AzureFileVolumeSource instance){
            this.withReadOnly(instance.isReadOnly());

            this.withSecretName(instance.getSecretName());

            this.withShareName(instance.getShareName());

    }

    public Boolean isReadOnly(){
            return this.readOnly;
    }

    public A withReadOnly(Boolean readOnly){
            this.readOnly=readOnly; return (A) this;
    }

    public Boolean hasReadOnly(){
            return this.readOnly != null;
    }

    public A withNewReadOnly(boolean arg1){
            return (A)withReadOnly(new Boolean(arg1));
    }

    public A withNewReadOnly(String arg1){
            return (A)withReadOnly(new Boolean(arg1));
    }

    public String getSecretName(){
            return this.secretName;
    }

    public A withSecretName(String secretName){
            this.secretName=secretName; return (A) this;
    }

    public Boolean hasSecretName(){
            return this.secretName != null;
    }

    public String getShareName(){
            return this.shareName;
    }

    public A withShareName(String shareName){
            this.shareName=shareName; return (A) this;
    }

    public Boolean hasShareName(){
            return this.shareName != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            V1AzureFileVolumeSourceFluentImpl that = (V1AzureFileVolumeSourceFluentImpl) o;
            if (readOnly != null ? !readOnly.equals(that.readOnly) :that.readOnly != null) return false;
            if (secretName != null ? !secretName.equals(that.secretName) :that.secretName != null) return false;
            if (shareName != null ? !shareName.equals(that.shareName) :that.shareName != null) return false;
            return true;
    }




}
