package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RuntimeRawExtensionBuilder extends RuntimeRawExtensionFluentImpl<RuntimeRawExtensionBuilder> implements VisitableBuilder<RuntimeRawExtension,RuntimeRawExtensionBuilder>{

    RuntimeRawExtensionFluent<?> fluent;
    Boolean validationEnabled;

    public RuntimeRawExtensionBuilder(){
            this(true);
    }
    public RuntimeRawExtensionBuilder(Boolean validationEnabled){
            this(new RuntimeRawExtension(), validationEnabled);
    }
    public RuntimeRawExtensionBuilder(RuntimeRawExtensionFluent<?> fluent){
            this(fluent, true);
    }
    public RuntimeRawExtensionBuilder(RuntimeRawExtensionFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new RuntimeRawExtension(), validationEnabled);
    }
    public RuntimeRawExtensionBuilder(RuntimeRawExtensionFluent<?> fluent,RuntimeRawExtension instance){
            this(fluent, instance, true);
    }
    public RuntimeRawExtensionBuilder(RuntimeRawExtensionFluent<?> fluent,RuntimeRawExtension instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withRaw(instance.getRaw());

            this.validationEnabled = validationEnabled; 
    }
    public RuntimeRawExtensionBuilder(RuntimeRawExtension instance){
            this(instance,true);
    }
    public RuntimeRawExtensionBuilder(RuntimeRawExtension instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withRaw(instance.getRaw());

            this.validationEnabled = validationEnabled; 
    }

    public RuntimeRawExtension build(){
            RuntimeRawExtension buildable = new RuntimeRawExtension();
            buildable.setRaw(fluent.getRaw());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RuntimeRawExtensionBuilder that = (RuntimeRawExtensionBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
