package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ExtensionsV1beta1ScaleSpecBuilder extends ExtensionsV1beta1ScaleSpecFluentImpl<ExtensionsV1beta1ScaleSpecBuilder> implements VisitableBuilder<ExtensionsV1beta1ScaleSpec,ExtensionsV1beta1ScaleSpecBuilder>{

    ExtensionsV1beta1ScaleSpecFluent<?> fluent;
    Boolean validationEnabled;

    public ExtensionsV1beta1ScaleSpecBuilder(){
            this(true);
    }
    public ExtensionsV1beta1ScaleSpecBuilder(Boolean validationEnabled){
            this(new ExtensionsV1beta1ScaleSpec(), validationEnabled);
    }
    public ExtensionsV1beta1ScaleSpecBuilder(ExtensionsV1beta1ScaleSpecFluent<?> fluent){
            this(fluent, true);
    }
    public ExtensionsV1beta1ScaleSpecBuilder(ExtensionsV1beta1ScaleSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ExtensionsV1beta1ScaleSpec(), validationEnabled);
    }
    public ExtensionsV1beta1ScaleSpecBuilder(ExtensionsV1beta1ScaleSpecFluent<?> fluent,ExtensionsV1beta1ScaleSpec instance){
            this(fluent, instance, true);
    }
    public ExtensionsV1beta1ScaleSpecBuilder(ExtensionsV1beta1ScaleSpecFluent<?> fluent,ExtensionsV1beta1ScaleSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withReplicas(instance.getReplicas());

            this.validationEnabled = validationEnabled; 
    }
    public ExtensionsV1beta1ScaleSpecBuilder(ExtensionsV1beta1ScaleSpec instance){
            this(instance,true);
    }
    public ExtensionsV1beta1ScaleSpecBuilder(ExtensionsV1beta1ScaleSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withReplicas(instance.getReplicas());

            this.validationEnabled = validationEnabled; 
    }

    public ExtensionsV1beta1ScaleSpec build(){
            ExtensionsV1beta1ScaleSpec buildable = new ExtensionsV1beta1ScaleSpec();
            buildable.setReplicas(fluent.getReplicas());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ExtensionsV1beta1ScaleSpecBuilder that = (ExtensionsV1beta1ScaleSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
