package io.kubernetes.client.models;

import io.kubernetes.client.fluent.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ExtensionsV1beta1DeploymentBuilder extends ExtensionsV1beta1DeploymentFluentImpl<ExtensionsV1beta1DeploymentBuilder> implements VisitableBuilder<ExtensionsV1beta1Deployment,ExtensionsV1beta1DeploymentBuilder>{

    ExtensionsV1beta1DeploymentFluent<?> fluent;
    Boolean validationEnabled;

    public ExtensionsV1beta1DeploymentBuilder(){
            this(true);
    }
    public ExtensionsV1beta1DeploymentBuilder(Boolean validationEnabled){
            this(new ExtensionsV1beta1Deployment(), validationEnabled);
    }
    public ExtensionsV1beta1DeploymentBuilder(ExtensionsV1beta1DeploymentFluent<?> fluent){
            this(fluent, true);
    }
    public ExtensionsV1beta1DeploymentBuilder(ExtensionsV1beta1DeploymentFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ExtensionsV1beta1Deployment(), validationEnabled);
    }
    public ExtensionsV1beta1DeploymentBuilder(ExtensionsV1beta1DeploymentFluent<?> fluent,ExtensionsV1beta1Deployment instance){
            this(fluent, instance, true);
    }
    public ExtensionsV1beta1DeploymentBuilder(ExtensionsV1beta1DeploymentFluent<?> fluent,ExtensionsV1beta1Deployment instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion());

            fluent.withKind(instance.getKind());

            fluent.withMetadata(instance.getMetadata());

            fluent.withSpec(instance.getSpec());

            fluent.withStatus(instance.getStatus());

            this.validationEnabled = validationEnabled; 
    }
    public ExtensionsV1beta1DeploymentBuilder(ExtensionsV1beta1Deployment instance){
            this(instance,true);
    }
    public ExtensionsV1beta1DeploymentBuilder(ExtensionsV1beta1Deployment instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion());

            this.withKind(instance.getKind());

            this.withMetadata(instance.getMetadata());

            this.withSpec(instance.getSpec());

            this.withStatus(instance.getStatus());

            this.validationEnabled = validationEnabled; 
    }

    public ExtensionsV1beta1Deployment build(){
            ExtensionsV1beta1Deployment buildable = new ExtensionsV1beta1Deployment();
            buildable.setApiVersion(fluent.getApiVersion());
            buildable.setKind(fluent.getKind());
            buildable.setMetadata(fluent.getMetadata());
            buildable.setSpec(fluent.getSpec());
            buildable.setStatus(fluent.getStatus());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ExtensionsV1beta1DeploymentBuilder that = (ExtensionsV1beta1DeploymentBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
