/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1alpha1VolumeError;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="VolumeAttachmentStatus is the status of a VolumeAttachment request.")
public class V1alpha1VolumeAttachmentStatus {
    @SerializedName(value="attachError")
    private V1alpha1VolumeError attachError = null;
    @SerializedName(value="attached")
    private Boolean attached = null;
    @SerializedName(value="attachmentMetadata")
    private Map<String, String> attachmentMetadata = null;
    @SerializedName(value="detachError")
    private V1alpha1VolumeError detachError = null;

    public V1alpha1VolumeAttachmentStatus attachError(V1alpha1VolumeError attachError) {
        this.attachError = attachError;
        return this;
    }

    @ApiModelProperty(value="The last error encountered during attach operation, if any. This field must only be set by the entity completing the attach operation, i.e. the external-attacher.")
    public V1alpha1VolumeError getAttachError() {
        return this.attachError;
    }

    public void setAttachError(V1alpha1VolumeError attachError) {
        this.attachError = attachError;
    }

    public V1alpha1VolumeAttachmentStatus attached(Boolean attached) {
        this.attached = attached;
        return this;
    }

    @ApiModelProperty(required=true, value="Indicates the volume is successfully attached. This field must only be set by the entity completing the attach operation, i.e. the external-attacher.")
    public Boolean isAttached() {
        return this.attached;
    }

    public void setAttached(Boolean attached) {
        this.attached = attached;
    }

    public V1alpha1VolumeAttachmentStatus attachmentMetadata(Map<String, String> attachmentMetadata) {
        this.attachmentMetadata = attachmentMetadata;
        return this;
    }

    public V1alpha1VolumeAttachmentStatus putAttachmentMetadataItem(String key, String attachmentMetadataItem) {
        if (this.attachmentMetadata == null) {
            this.attachmentMetadata = new HashMap<String, String>();
        }
        this.attachmentMetadata.put(key, attachmentMetadataItem);
        return this;
    }

    @ApiModelProperty(value="Upon successful attach, this field is populated with any information returned by the attach operation that must be passed into subsequent WaitForAttach or Mount calls. This field must only be set by the entity completing the attach operation, i.e. the external-attacher.")
    public Map<String, String> getAttachmentMetadata() {
        return this.attachmentMetadata;
    }

    public void setAttachmentMetadata(Map<String, String> attachmentMetadata) {
        this.attachmentMetadata = attachmentMetadata;
    }

    public V1alpha1VolumeAttachmentStatus detachError(V1alpha1VolumeError detachError) {
        this.detachError = detachError;
        return this;
    }

    @ApiModelProperty(value="The last error encountered during detach operation, if any. This field must only be set by the entity completing the detach operation, i.e. the external-attacher.")
    public V1alpha1VolumeError getDetachError() {
        return this.detachError;
    }

    public void setDetachError(V1alpha1VolumeError detachError) {
        this.detachError = detachError;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha1VolumeAttachmentStatus v1alpha1VolumeAttachmentStatus = (V1alpha1VolumeAttachmentStatus)o;
        return Objects.equals(this.attachError, v1alpha1VolumeAttachmentStatus.attachError) && Objects.equals(this.attached, v1alpha1VolumeAttachmentStatus.attached) && Objects.equals(this.attachmentMetadata, v1alpha1VolumeAttachmentStatus.attachmentMetadata) && Objects.equals(this.detachError, v1alpha1VolumeAttachmentStatus.detachError);
    }

    public int hashCode() {
        return Objects.hash(this.attachError, this.attached, this.attachmentMetadata, this.detachError);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha1VolumeAttachmentStatus {\n");
        sb.append("    attachError: ").append(this.toIndentedString(this.attachError)).append("\n");
        sb.append("    attached: ").append(this.toIndentedString(this.attached)).append("\n");
        sb.append("    attachmentMetadata: ").append(this.toIndentedString(this.attachmentMetadata)).append("\n");
        sb.append("    detachError: ").append(this.toIndentedString(this.detachError)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

