/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1ObjectMeta;
import io.kubernetes.client.models.V1alpha1Initializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="InitializerConfiguration describes the configuration of initializers.")
public class V1alpha1InitializerConfiguration {
    @SerializedName(value="apiVersion")
    private String apiVersion = null;
    @SerializedName(value="initializers")
    private List<V1alpha1Initializer> initializers = null;
    @SerializedName(value="kind")
    private String kind = null;
    @SerializedName(value="metadata")
    private V1ObjectMeta metadata = null;

    public V1alpha1InitializerConfiguration apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @ApiModelProperty(value="APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1alpha1InitializerConfiguration initializers(List<V1alpha1Initializer> initializers) {
        this.initializers = initializers;
        return this;
    }

    public V1alpha1InitializerConfiguration addInitializersItem(V1alpha1Initializer initializersItem) {
        if (this.initializers == null) {
            this.initializers = new ArrayList<V1alpha1Initializer>();
        }
        this.initializers.add(initializersItem);
        return this;
    }

    @ApiModelProperty(value="Initializers is a list of resources and their default initializers Order-sensitive. When merging multiple InitializerConfigurations, we sort the initializers from different InitializerConfigurations by the name of the InitializerConfigurations; the order of the initializers from the same InitializerConfiguration is preserved.")
    public List<V1alpha1Initializer> getInitializers() {
        return this.initializers;
    }

    public void setInitializers(List<V1alpha1Initializer> initializers) {
        this.initializers = initializers;
    }

    public V1alpha1InitializerConfiguration kind(String kind) {
        this.kind = kind;
        return this;
    }

    @ApiModelProperty(value="Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds")
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1alpha1InitializerConfiguration metadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(value="Standard object metadata; More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata.")
    public V1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha1InitializerConfiguration v1alpha1InitializerConfiguration = (V1alpha1InitializerConfiguration)o;
        return Objects.equals(this.apiVersion, v1alpha1InitializerConfiguration.apiVersion) && Objects.equals(this.initializers, v1alpha1InitializerConfiguration.initializers) && Objects.equals(this.kind, v1alpha1InitializerConfiguration.kind) && Objects.equals(this.metadata, v1alpha1InitializerConfiguration.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.initializers, this.kind, this.metadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha1InitializerConfiguration {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    initializers: ").append(this.toIndentedString(this.initializers)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

