/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1ObjectMeta;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="Secret holds secret data of a certain type. The total bytes of the values in the Data field must be less than MaxSecretSize bytes.")
public class V1Secret {
    @SerializedName(value="apiVersion")
    private String apiVersion = null;
    @SerializedName(value="data")
    private Map<String, byte[]> data = null;
    @SerializedName(value="kind")
    private String kind = null;
    @SerializedName(value="metadata")
    private V1ObjectMeta metadata = null;
    @SerializedName(value="stringData")
    private Map<String, String> stringData = null;
    @SerializedName(value="type")
    private String type = null;

    public V1Secret apiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @ApiModelProperty(value="APIVersion defines the versioned schema of this representation of an object. Servers should convert recognized schemas to the latest internal value, and may reject unrecognized values. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#resources")
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public V1Secret data(Map<String, byte[]> data) {
        this.data = data;
        return this;
    }

    public V1Secret putDataItem(String key, byte[] dataItem) {
        if (this.data == null) {
            this.data = new HashMap<String, byte[]>();
        }
        this.data.put(key, dataItem);
        return this;
    }

    @ApiModelProperty(value="Data contains the secret data. Each key must consist of alphanumeric characters, '-', '_' or '.'. The serialized form of the secret data is a base64 encoded string, representing the arbitrary (possibly non-string) data value here. Described in https://tools.ietf.org/html/rfc4648#section-4")
    public Map<String, byte[]> getData() {
        return this.data;
    }

    public void setData(Map<String, byte[]> data) {
        this.data = data;
    }

    public V1Secret kind(String kind) {
        this.kind = kind;
        return this;
    }

    @ApiModelProperty(value="Kind is a string value representing the REST resource this object represents. Servers may infer this from the endpoint the client submits requests to. Cannot be updated. In CamelCase. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#types-kinds")
    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public V1Secret metadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
        return this;
    }

    @ApiModelProperty(value="Standard object's metadata. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata")
    public V1ObjectMeta getMetadata() {
        return this.metadata;
    }

    public void setMetadata(V1ObjectMeta metadata) {
        this.metadata = metadata;
    }

    public V1Secret stringData(Map<String, String> stringData) {
        this.stringData = stringData;
        return this;
    }

    public V1Secret putStringDataItem(String key, String stringDataItem) {
        if (this.stringData == null) {
            this.stringData = new HashMap<String, String>();
        }
        this.stringData.put(key, stringDataItem);
        return this;
    }

    @ApiModelProperty(value="stringData allows specifying non-binary secret data in string form. It is provided as a write-only convenience method. All keys and values are merged into the data field on write, overwriting any existing values. It is never output when reading from the API.")
    public Map<String, String> getStringData() {
        return this.stringData;
    }

    public void setStringData(Map<String, String> stringData) {
        this.stringData = stringData;
    }

    public V1Secret type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(value="Used to facilitate programmatic handling of secret data.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1Secret v1Secret = (V1Secret)o;
        return Objects.equals(this.apiVersion, v1Secret.apiVersion) && Objects.equals(this.data, v1Secret.data) && Objects.equals(this.kind, v1Secret.kind) && Objects.equals(this.metadata, v1Secret.metadata) && Objects.equals(this.stringData, v1Secret.stringData) && Objects.equals(this.type, v1Secret.type);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.data, this.kind, this.metadata, this.stringData, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1Secret {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    stringData: ").append(this.toIndentedString(this.stringData)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

