/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="LoadBalancerIngress represents the status of a load-balancer ingress point: traffic intended for the service should be sent to an ingress point.")
public class V1LoadBalancerIngress {
    @SerializedName(value="hostname")
    private String hostname = null;
    @SerializedName(value="ip")
    private String ip = null;

    public V1LoadBalancerIngress hostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    @ApiModelProperty(value="Hostname is set for load-balancer ingress points that are DNS based (typically AWS load-balancers)")
    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public V1LoadBalancerIngress ip(String ip) {
        this.ip = ip;
        return this;
    }

    @ApiModelProperty(value="IP is set for load-balancer ingress points that are IP based (typically GCE or OpenStack load-balancers)")
    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1LoadBalancerIngress v1LoadBalancerIngress = (V1LoadBalancerIngress)o;
        return Objects.equals(this.hostname, v1LoadBalancerIngress.hostname) && Objects.equals(this.ip, v1LoadBalancerIngress.ip);
    }

    public int hashCode() {
        return Objects.hash(this.hostname, this.ip);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1LoadBalancerIngress {\n");
        sb.append("    hostname: ").append(this.toIndentedString(this.hostname)).append("\n");
        sb.append("    ip: ").append(this.toIndentedString(this.ip)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

