/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="PolicyRule holds information that describes a policy rule, but does not contain information about who the rule applies to or which namespace the rule applies to.")
public class V1PolicyRule {
    public static final String SERIALIZED_NAME_API_GROUPS = "apiGroups";
    @SerializedName(value="apiGroups")
    private List<String> apiGroups = new ArrayList<String>();
    public static final String SERIALIZED_NAME_NON_RESOURCE_U_R_LS = "nonResourceURLs";
    @SerializedName(value="nonResourceURLs")
    private List<String> nonResourceURLs = new ArrayList<String>();
    public static final String SERIALIZED_NAME_RESOURCE_NAMES = "resourceNames";
    @SerializedName(value="resourceNames")
    private List<String> resourceNames = new ArrayList<String>();
    public static final String SERIALIZED_NAME_RESOURCES = "resources";
    @SerializedName(value="resources")
    private List<String> resources = new ArrayList<String>();
    public static final String SERIALIZED_NAME_VERBS = "verbs";
    @SerializedName(value="verbs")
    private List<String> verbs = new ArrayList<String>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1PolicyRule apiGroups(List<String> apiGroups) {
        this.apiGroups = apiGroups;
        return this;
    }

    public V1PolicyRule addApiGroupsItem(String apiGroupsItem) {
        if (this.apiGroups == null) {
            this.apiGroups = new ArrayList<String>();
        }
        this.apiGroups.add(apiGroupsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="APIGroups is the name of the APIGroup that contains the resources.  If multiple API groups are specified, any action requested against one of the enumerated resources in any API group will be allowed. \"\" represents the core API group and \"*\" represents all API groups.")
    public List<String> getApiGroups() {
        return this.apiGroups;
    }

    public void setApiGroups(List<String> apiGroups) {
        this.apiGroups = apiGroups;
    }

    public V1PolicyRule nonResourceURLs(List<String> nonResourceURLs) {
        this.nonResourceURLs = nonResourceURLs;
        return this;
    }

    public V1PolicyRule addNonResourceURLsItem(String nonResourceURLsItem) {
        if (this.nonResourceURLs == null) {
            this.nonResourceURLs = new ArrayList<String>();
        }
        this.nonResourceURLs.add(nonResourceURLsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="NonResourceURLs is a set of partial urls that a user should have access to.  *s are allowed, but only as the full, final step in the path Since non-resource URLs are not namespaced, this field is only applicable for ClusterRoles referenced from a ClusterRoleBinding. Rules can either apply to API resources (such as \"pods\" or \"secrets\") or non-resource URL paths (such as \"/api\"),  but not both.")
    public List<String> getNonResourceURLs() {
        return this.nonResourceURLs;
    }

    public void setNonResourceURLs(List<String> nonResourceURLs) {
        this.nonResourceURLs = nonResourceURLs;
    }

    public V1PolicyRule resourceNames(List<String> resourceNames) {
        this.resourceNames = resourceNames;
        return this;
    }

    public V1PolicyRule addResourceNamesItem(String resourceNamesItem) {
        if (this.resourceNames == null) {
            this.resourceNames = new ArrayList<String>();
        }
        this.resourceNames.add(resourceNamesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ResourceNames is an optional white list of names that the rule applies to.  An empty set means that everything is allowed.")
    public List<String> getResourceNames() {
        return this.resourceNames;
    }

    public void setResourceNames(List<String> resourceNames) {
        this.resourceNames = resourceNames;
    }

    public V1PolicyRule resources(List<String> resources) {
        this.resources = resources;
        return this;
    }

    public V1PolicyRule addResourcesItem(String resourcesItem) {
        if (this.resources == null) {
            this.resources = new ArrayList<String>();
        }
        this.resources.add(resourcesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Resources is a list of resources this rule applies to. '*' represents all resources.")
    public List<String> getResources() {
        return this.resources;
    }

    public void setResources(List<String> resources) {
        this.resources = resources;
    }

    public V1PolicyRule verbs(List<String> verbs) {
        this.verbs = verbs;
        return this;
    }

    public V1PolicyRule addVerbsItem(String verbsItem) {
        if (this.verbs == null) {
            this.verbs = new ArrayList<String>();
        }
        this.verbs.add(verbsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Verbs is a list of Verbs that apply to ALL the ResourceKinds contained in this rule. '*' represents all verbs.")
    public List<String> getVerbs() {
        return this.verbs;
    }

    public void setVerbs(List<String> verbs) {
        this.verbs = verbs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1PolicyRule v1PolicyRule = (V1PolicyRule)o;
        return Objects.equals(this.apiGroups, v1PolicyRule.apiGroups) && Objects.equals(this.nonResourceURLs, v1PolicyRule.nonResourceURLs) && Objects.equals(this.resourceNames, v1PolicyRule.resourceNames) && Objects.equals(this.resources, v1PolicyRule.resources) && Objects.equals(this.verbs, v1PolicyRule.verbs);
    }

    public int hashCode() {
        return Objects.hash(this.apiGroups, this.nonResourceURLs, this.resourceNames, this.resources, this.verbs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1PolicyRule {\n");
        sb.append("    apiGroups: ").append(this.toIndentedString(this.apiGroups)).append("\n");
        sb.append("    nonResourceURLs: ").append(this.toIndentedString(this.nonResourceURLs)).append("\n");
        sb.append("    resourceNames: ").append(this.toIndentedString(this.resourceNames)).append("\n");
        sb.append("    resources: ").append(this.toIndentedString(this.resources)).append("\n");
        sb.append("    verbs: ").append(this.toIndentedString(this.verbs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1PolicyRule is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1PolicyRule` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_API_GROUPS) != null && !jsonObj.get(SERIALIZED_NAME_API_GROUPS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_API_GROUPS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `apiGroups` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_API_GROUPS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NON_RESOURCE_U_R_LS) != null && !jsonObj.get(SERIALIZED_NAME_NON_RESOURCE_U_R_LS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NON_RESOURCE_U_R_LS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `nonResourceURLs` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NON_RESOURCE_U_R_LS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RESOURCE_NAMES) != null && !jsonObj.get(SERIALIZED_NAME_RESOURCE_NAMES).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_RESOURCE_NAMES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `resourceNames` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESOURCE_NAMES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RESOURCES) != null && !jsonObj.get(SERIALIZED_NAME_RESOURCES).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_RESOURCES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `resources` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESOURCES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_VERBS) == null) {
            throw new IllegalArgumentException("Expected the field `linkedContent` to be an array in the JSON string but got `null`");
        }
        if (!jsonObj.get(SERIALIZED_NAME_VERBS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `verbs` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VERBS).toString()));
        }
    }

    public static V1PolicyRule fromJson(String jsonString) throws IOException {
        return (V1PolicyRule)JSON.getGson().fromJson(jsonString, V1PolicyRule.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_API_GROUPS);
        openapiFields.add(SERIALIZED_NAME_NON_RESOURCE_U_R_LS);
        openapiFields.add(SERIALIZED_NAME_RESOURCE_NAMES);
        openapiFields.add(SERIALIZED_NAME_RESOURCES);
        openapiFields.add(SERIALIZED_NAME_VERBS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_VERBS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1PolicyRule.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1PolicyRule.class));
            return new TypeAdapter<V1PolicyRule>(){

                public void write(JsonWriter out, V1PolicyRule value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1PolicyRule read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1PolicyRule.validateJsonElement(jsonElement);
                    return (V1PolicyRule)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

