/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V2HPAScalingPolicy;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="HPAScalingRules configures the scaling behavior for one direction. These Rules are applied after calculating DesiredReplicas from metrics for the HPA. They can limit the scaling velocity by specifying scaling policies. They can prevent flapping by specifying the stabilization window, so that the number of replicas is not set instantly, instead, the safest value from the stabilization window is chosen.")
public class V2HPAScalingRules {
    public static final String SERIALIZED_NAME_POLICIES = "policies";
    @SerializedName(value="policies")
    private List<V2HPAScalingPolicy> policies = new ArrayList<V2HPAScalingPolicy>();
    public static final String SERIALIZED_NAME_SELECT_POLICY = "selectPolicy";
    @SerializedName(value="selectPolicy")
    private String selectPolicy;
    public static final String SERIALIZED_NAME_STABILIZATION_WINDOW_SECONDS = "stabilizationWindowSeconds";
    @SerializedName(value="stabilizationWindowSeconds")
    private Integer stabilizationWindowSeconds;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V2HPAScalingRules policies(List<V2HPAScalingPolicy> policies) {
        this.policies = policies;
        return this;
    }

    public V2HPAScalingRules addPoliciesItem(V2HPAScalingPolicy policiesItem) {
        if (this.policies == null) {
            this.policies = new ArrayList<V2HPAScalingPolicy>();
        }
        this.policies.add(policiesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="policies is a list of potential scaling polices which can be used during scaling. At least one policy must be specified, otherwise the HPAScalingRules will be discarded as invalid")
    public List<V2HPAScalingPolicy> getPolicies() {
        return this.policies;
    }

    public void setPolicies(List<V2HPAScalingPolicy> policies) {
        this.policies = policies;
    }

    public V2HPAScalingRules selectPolicy(String selectPolicy) {
        this.selectPolicy = selectPolicy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="selectPolicy is used to specify which policy should be used. If not set, the default value Max is used.")
    public String getSelectPolicy() {
        return this.selectPolicy;
    }

    public void setSelectPolicy(String selectPolicy) {
        this.selectPolicy = selectPolicy;
    }

    public V2HPAScalingRules stabilizationWindowSeconds(Integer stabilizationWindowSeconds) {
        this.stabilizationWindowSeconds = stabilizationWindowSeconds;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="stabilizationWindowSeconds is the number of seconds for which past recommendations should be considered while scaling up or scaling down. StabilizationWindowSeconds must be greater than or equal to zero and less than or equal to 3600 (one hour). If not set, use the default values: - For scale up: 0 (i.e. no stabilization is done). - For scale down: 300 (i.e. the stabilization window is 300 seconds long).")
    public Integer getStabilizationWindowSeconds() {
        return this.stabilizationWindowSeconds;
    }

    public void setStabilizationWindowSeconds(Integer stabilizationWindowSeconds) {
        this.stabilizationWindowSeconds = stabilizationWindowSeconds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V2HPAScalingRules v2HPAScalingRules = (V2HPAScalingRules)o;
        return Objects.equals(this.policies, v2HPAScalingRules.policies) && Objects.equals(this.selectPolicy, v2HPAScalingRules.selectPolicy) && Objects.equals(this.stabilizationWindowSeconds, v2HPAScalingRules.stabilizationWindowSeconds);
    }

    public int hashCode() {
        return Objects.hash(this.policies, this.selectPolicy, this.stabilizationWindowSeconds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V2HPAScalingRules {\n");
        sb.append("    policies: ").append(this.toIndentedString(this.policies)).append("\n");
        sb.append("    selectPolicy: ").append(this.toIndentedString(this.selectPolicy)).append("\n");
        sb.append("    stabilizationWindowSeconds: ").append(this.toIndentedString(this.stabilizationWindowSeconds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArraypolicies;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V2HPAScalingRules is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V2HPAScalingRules` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_POLICIES) != null && !jsonObj.get(SERIALIZED_NAME_POLICIES).isJsonNull() && (jsonArraypolicies = jsonObj.getAsJsonArray(SERIALIZED_NAME_POLICIES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_POLICIES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `policies` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_POLICIES).toString()));
            }
            for (int i = 0; i < jsonArraypolicies.size(); ++i) {
                V2HPAScalingPolicy.validateJsonElement(jsonArraypolicies.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_SELECT_POLICY) != null && !jsonObj.get(SERIALIZED_NAME_SELECT_POLICY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SELECT_POLICY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `selectPolicy` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SELECT_POLICY).toString()));
        }
    }

    public static V2HPAScalingRules fromJson(String jsonString) throws IOException {
        return (V2HPAScalingRules)JSON.getGson().fromJson(jsonString, V2HPAScalingRules.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_POLICIES);
        openapiFields.add(SERIALIZED_NAME_SELECT_POLICY);
        openapiFields.add(SERIALIZED_NAME_STABILIZATION_WINDOW_SECONDS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V2HPAScalingRules.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V2HPAScalingRules.class));
            return new TypeAdapter<V2HPAScalingRules>(){

                public void write(JsonWriter out, V2HPAScalingRules value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V2HPAScalingRules read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V2HPAScalingRules.validateJsonElement(jsonElement);
                    return (V2HPAScalingRules)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

