/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="ResourceClaimSchedulingStatus contains information about one particular ResourceClaim with \"WaitForFirstConsumer\" allocation mode.")
public class V1alpha3ResourceClaimSchedulingStatus {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_UNSUITABLE_NODES = "unsuitableNodes";
    @SerializedName(value="unsuitableNodes")
    private List<String> unsuitableNodes = new ArrayList<String>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1alpha3ResourceClaimSchedulingStatus name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Name matches the pod.spec.resourceClaims[*].Name field.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1alpha3ResourceClaimSchedulingStatus unsuitableNodes(List<String> unsuitableNodes) {
        this.unsuitableNodes = unsuitableNodes;
        return this;
    }

    public V1alpha3ResourceClaimSchedulingStatus addUnsuitableNodesItem(String unsuitableNodesItem) {
        if (this.unsuitableNodes == null) {
            this.unsuitableNodes = new ArrayList<String>();
        }
        this.unsuitableNodes.add(unsuitableNodesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="UnsuitableNodes lists nodes that the ResourceClaim cannot be allocated for.  The size of this field is limited to 128, the same as for PodSchedulingSpec.PotentialNodes. This may get increased in the future, but not reduced.")
    public List<String> getUnsuitableNodes() {
        return this.unsuitableNodes;
    }

    public void setUnsuitableNodes(List<String> unsuitableNodes) {
        this.unsuitableNodes = unsuitableNodes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha3ResourceClaimSchedulingStatus v1alpha3ResourceClaimSchedulingStatus = (V1alpha3ResourceClaimSchedulingStatus)o;
        return Objects.equals(this.name, v1alpha3ResourceClaimSchedulingStatus.name) && Objects.equals(this.unsuitableNodes, v1alpha3ResourceClaimSchedulingStatus.unsuitableNodes);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.unsuitableNodes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha3ResourceClaimSchedulingStatus {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    unsuitableNodes: ").append(this.toIndentedString(this.unsuitableNodes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1alpha3ResourceClaimSchedulingStatus is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1alpha3ResourceClaimSchedulingStatus` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_UNSUITABLE_NODES) != null && !jsonObj.get(SERIALIZED_NAME_UNSUITABLE_NODES).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_UNSUITABLE_NODES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `unsuitableNodes` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_UNSUITABLE_NODES).toString()));
        }
    }

    public static V1alpha3ResourceClaimSchedulingStatus fromJson(String jsonString) throws IOException {
        return (V1alpha3ResourceClaimSchedulingStatus)JSON.getGson().fromJson(jsonString, V1alpha3ResourceClaimSchedulingStatus.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_UNSUITABLE_NODES);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1alpha3ResourceClaimSchedulingStatus.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1alpha3ResourceClaimSchedulingStatus.class));
            return new TypeAdapter<V1alpha3ResourceClaimSchedulingStatus>(){

                public void write(JsonWriter out, V1alpha3ResourceClaimSchedulingStatus value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1alpha3ResourceClaimSchedulingStatus read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1alpha3ResourceClaimSchedulingStatus.validateJsonElement(jsonElement);
                    return (V1alpha3ResourceClaimSchedulingStatus)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

