/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="PodSchedulingContextSpec describes where resources for the Pod are needed.")
public class V1alpha3PodSchedulingContextSpec {
    public static final String SERIALIZED_NAME_POTENTIAL_NODES = "potentialNodes";
    @SerializedName(value="potentialNodes")
    private List<String> potentialNodes = new ArrayList<String>();
    public static final String SERIALIZED_NAME_SELECTED_NODE = "selectedNode";
    @SerializedName(value="selectedNode")
    private String selectedNode;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1alpha3PodSchedulingContextSpec potentialNodes(List<String> potentialNodes) {
        this.potentialNodes = potentialNodes;
        return this;
    }

    public V1alpha3PodSchedulingContextSpec addPotentialNodesItem(String potentialNodesItem) {
        if (this.potentialNodes == null) {
            this.potentialNodes = new ArrayList<String>();
        }
        this.potentialNodes.add(potentialNodesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="PotentialNodes lists nodes where the Pod might be able to run.  The size of this field is limited to 128. This is large enough for many clusters. Larger clusters may need more attempts to find a node that suits all pending resources. This may get increased in the future, but not reduced.")
    public List<String> getPotentialNodes() {
        return this.potentialNodes;
    }

    public void setPotentialNodes(List<String> potentialNodes) {
        this.potentialNodes = potentialNodes;
    }

    public V1alpha3PodSchedulingContextSpec selectedNode(String selectedNode) {
        this.selectedNode = selectedNode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="SelectedNode is the node for which allocation of ResourceClaims that are referenced by the Pod and that use \"WaitForFirstConsumer\" allocation is to be attempted.")
    public String getSelectedNode() {
        return this.selectedNode;
    }

    public void setSelectedNode(String selectedNode) {
        this.selectedNode = selectedNode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha3PodSchedulingContextSpec v1alpha3PodSchedulingContextSpec = (V1alpha3PodSchedulingContextSpec)o;
        return Objects.equals(this.potentialNodes, v1alpha3PodSchedulingContextSpec.potentialNodes) && Objects.equals(this.selectedNode, v1alpha3PodSchedulingContextSpec.selectedNode);
    }

    public int hashCode() {
        return Objects.hash(this.potentialNodes, this.selectedNode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha3PodSchedulingContextSpec {\n");
        sb.append("    potentialNodes: ").append(this.toIndentedString(this.potentialNodes)).append("\n");
        sb.append("    selectedNode: ").append(this.toIndentedString(this.selectedNode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1alpha3PodSchedulingContextSpec is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1alpha3PodSchedulingContextSpec` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_POTENTIAL_NODES) != null && !jsonObj.get(SERIALIZED_NAME_POTENTIAL_NODES).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_POTENTIAL_NODES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `potentialNodes` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_POTENTIAL_NODES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SELECTED_NODE) != null && !jsonObj.get(SERIALIZED_NAME_SELECTED_NODE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SELECTED_NODE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `selectedNode` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SELECTED_NODE).toString()));
        }
    }

    public static V1alpha3PodSchedulingContextSpec fromJson(String jsonString) throws IOException {
        return (V1alpha3PodSchedulingContextSpec)JSON.getGson().fromJson(jsonString, V1alpha3PodSchedulingContextSpec.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_POTENTIAL_NODES);
        openapiFields.add(SERIALIZED_NAME_SELECTED_NODE);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1alpha3PodSchedulingContextSpec.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1alpha3PodSchedulingContextSpec.class));
            return new TypeAdapter<V1alpha3PodSchedulingContextSpec>(){

                public void write(JsonWriter out, V1alpha3PodSchedulingContextSpec value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1alpha3PodSchedulingContextSpec read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1alpha3PodSchedulingContextSpec.validateJsonElement(jsonElement);
                    return (V1alpha3PodSchedulingContextSpec)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

