/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1NodeSelector;
import io.kubernetes.client.openapi.models.V1alpha3DeviceClassConfiguration;
import io.kubernetes.client.openapi.models.V1alpha3DeviceSelector;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="DeviceClassSpec is used in a [DeviceClass] to define what can be allocated and how to configure it.")
public class V1alpha3DeviceClassSpec {
    public static final String SERIALIZED_NAME_CONFIG = "config";
    @SerializedName(value="config")
    private List<V1alpha3DeviceClassConfiguration> config = new ArrayList<V1alpha3DeviceClassConfiguration>();
    public static final String SERIALIZED_NAME_SELECTORS = "selectors";
    @SerializedName(value="selectors")
    private List<V1alpha3DeviceSelector> selectors = new ArrayList<V1alpha3DeviceSelector>();
    public static final String SERIALIZED_NAME_SUITABLE_NODES = "suitableNodes";
    @SerializedName(value="suitableNodes")
    private V1NodeSelector suitableNodes;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1alpha3DeviceClassSpec config(List<V1alpha3DeviceClassConfiguration> config) {
        this.config = config;
        return this;
    }

    public V1alpha3DeviceClassSpec addConfigItem(V1alpha3DeviceClassConfiguration configItem) {
        if (this.config == null) {
            this.config = new ArrayList<V1alpha3DeviceClassConfiguration>();
        }
        this.config.add(configItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Config defines configuration parameters that apply to each device that is claimed via this class. Some classses may potentially be satisfied by multiple drivers, so each instance of a vendor configuration applies to exactly one driver.  They are passed to the driver, but are not considered while allocating the claim.")
    public List<V1alpha3DeviceClassConfiguration> getConfig() {
        return this.config;
    }

    public void setConfig(List<V1alpha3DeviceClassConfiguration> config) {
        this.config = config;
    }

    public V1alpha3DeviceClassSpec selectors(List<V1alpha3DeviceSelector> selectors) {
        this.selectors = selectors;
        return this;
    }

    public V1alpha3DeviceClassSpec addSelectorsItem(V1alpha3DeviceSelector selectorsItem) {
        if (this.selectors == null) {
            this.selectors = new ArrayList<V1alpha3DeviceSelector>();
        }
        this.selectors.add(selectorsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Each selector must be satisfied by a device which is claimed via this class.")
    public List<V1alpha3DeviceSelector> getSelectors() {
        return this.selectors;
    }

    public void setSelectors(List<V1alpha3DeviceSelector> selectors) {
        this.selectors = selectors;
    }

    public V1alpha3DeviceClassSpec suitableNodes(V1NodeSelector suitableNodes) {
        this.suitableNodes = suitableNodes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1NodeSelector getSuitableNodes() {
        return this.suitableNodes;
    }

    public void setSuitableNodes(V1NodeSelector suitableNodes) {
        this.suitableNodes = suitableNodes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha3DeviceClassSpec v1alpha3DeviceClassSpec = (V1alpha3DeviceClassSpec)o;
        return Objects.equals(this.config, v1alpha3DeviceClassSpec.config) && Objects.equals(this.selectors, v1alpha3DeviceClassSpec.selectors) && Objects.equals(this.suitableNodes, v1alpha3DeviceClassSpec.suitableNodes);
    }

    public int hashCode() {
        return Objects.hash(this.config, this.selectors, this.suitableNodes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha3DeviceClassSpec {\n");
        sb.append("    config: ").append(this.toIndentedString(this.config)).append("\n");
        sb.append("    selectors: ").append(this.toIndentedString(this.selectors)).append("\n");
        sb.append("    suitableNodes: ").append(this.toIndentedString(this.suitableNodes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayselectors;
        int i;
        JsonArray jsonArrayconfig;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1alpha3DeviceClassSpec is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1alpha3DeviceClassSpec` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_CONFIG) != null && !jsonObj.get(SERIALIZED_NAME_CONFIG).isJsonNull() && (jsonArrayconfig = jsonObj.getAsJsonArray(SERIALIZED_NAME_CONFIG)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_CONFIG).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `config` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONFIG).toString()));
            }
            for (i = 0; i < jsonArrayconfig.size(); ++i) {
                V1alpha3DeviceClassConfiguration.validateJsonElement(jsonArrayconfig.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_SELECTORS) != null && !jsonObj.get(SERIALIZED_NAME_SELECTORS).isJsonNull() && (jsonArrayselectors = jsonObj.getAsJsonArray(SERIALIZED_NAME_SELECTORS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_SELECTORS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `selectors` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SELECTORS).toString()));
            }
            for (i = 0; i < jsonArrayselectors.size(); ++i) {
                V1alpha3DeviceSelector.validateJsonElement(jsonArrayselectors.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_SUITABLE_NODES) != null && !jsonObj.get(SERIALIZED_NAME_SUITABLE_NODES).isJsonNull()) {
            V1NodeSelector.validateJsonElement(jsonObj.get(SERIALIZED_NAME_SUITABLE_NODES));
        }
    }

    public static V1alpha3DeviceClassSpec fromJson(String jsonString) throws IOException {
        return (V1alpha3DeviceClassSpec)JSON.getGson().fromJson(jsonString, V1alpha3DeviceClassSpec.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CONFIG);
        openapiFields.add(SERIALIZED_NAME_SELECTORS);
        openapiFields.add(SERIALIZED_NAME_SUITABLE_NODES);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1alpha3DeviceClassSpec.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1alpha3DeviceClassSpec.class));
            return new TypeAdapter<V1alpha3DeviceClassSpec>(){

                public void write(JsonWriter out, V1alpha3DeviceClassSpec value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1alpha3DeviceClassSpec read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1alpha3DeviceClassSpec.validateJsonElement(jsonElement);
                    return (V1alpha3DeviceClassSpec)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

