/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.kubernetes.client.openapi.models.V1alpha1AuditAnnotation;
import io.kubernetes.client.openapi.models.V1alpha1MatchCondition;
import io.kubernetes.client.openapi.models.V1alpha1MatchResources;
import io.kubernetes.client.openapi.models.V1alpha1ParamKind;
import io.kubernetes.client.openapi.models.V1alpha1Validation;
import io.kubernetes.client.openapi.models.V1alpha1Variable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="ValidatingAdmissionPolicySpec is the specification of the desired behavior of the AdmissionPolicy.")
public class V1alpha1ValidatingAdmissionPolicySpec {
    public static final String SERIALIZED_NAME_AUDIT_ANNOTATIONS = "auditAnnotations";
    @SerializedName(value="auditAnnotations")
    private List<V1alpha1AuditAnnotation> auditAnnotations = new ArrayList<V1alpha1AuditAnnotation>();
    public static final String SERIALIZED_NAME_FAILURE_POLICY = "failurePolicy";
    @SerializedName(value="failurePolicy")
    private String failurePolicy;
    public static final String SERIALIZED_NAME_MATCH_CONDITIONS = "matchConditions";
    @SerializedName(value="matchConditions")
    private List<V1alpha1MatchCondition> matchConditions = new ArrayList<V1alpha1MatchCondition>();
    public static final String SERIALIZED_NAME_MATCH_CONSTRAINTS = "matchConstraints";
    @SerializedName(value="matchConstraints")
    private V1alpha1MatchResources matchConstraints;
    public static final String SERIALIZED_NAME_PARAM_KIND = "paramKind";
    @SerializedName(value="paramKind")
    private V1alpha1ParamKind paramKind;
    public static final String SERIALIZED_NAME_VALIDATIONS = "validations";
    @SerializedName(value="validations")
    private List<V1alpha1Validation> validations = new ArrayList<V1alpha1Validation>();
    public static final String SERIALIZED_NAME_VARIABLES = "variables";
    @SerializedName(value="variables")
    private List<V1alpha1Variable> variables = new ArrayList<V1alpha1Variable>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1alpha1ValidatingAdmissionPolicySpec auditAnnotations(List<V1alpha1AuditAnnotation> auditAnnotations) {
        this.auditAnnotations = auditAnnotations;
        return this;
    }

    public V1alpha1ValidatingAdmissionPolicySpec addAuditAnnotationsItem(V1alpha1AuditAnnotation auditAnnotationsItem) {
        if (this.auditAnnotations == null) {
            this.auditAnnotations = new ArrayList<V1alpha1AuditAnnotation>();
        }
        this.auditAnnotations.add(auditAnnotationsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="auditAnnotations contains CEL expressions which are used to produce audit annotations for the audit event of the API request. validations and auditAnnotations may not both be empty; a least one of validations or auditAnnotations is required.")
    public List<V1alpha1AuditAnnotation> getAuditAnnotations() {
        return this.auditAnnotations;
    }

    public void setAuditAnnotations(List<V1alpha1AuditAnnotation> auditAnnotations) {
        this.auditAnnotations = auditAnnotations;
    }

    public V1alpha1ValidatingAdmissionPolicySpec failurePolicy(String failurePolicy) {
        this.failurePolicy = failurePolicy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="failurePolicy defines how to handle failures for the admission policy. Failures can occur from CEL expression parse errors, type check errors, runtime errors and invalid or mis-configured policy definitions or bindings.  A policy is invalid if spec.paramKind refers to a non-existent Kind. A binding is invalid if spec.paramRef.name refers to a non-existent resource.  failurePolicy does not define how validations that evaluate to false are handled.  When failurePolicy is set to Fail, ValidatingAdmissionPolicyBinding validationActions define how failures are enforced.  Allowed values are Ignore or Fail. Defaults to Fail.")
    public String getFailurePolicy() {
        return this.failurePolicy;
    }

    public void setFailurePolicy(String failurePolicy) {
        this.failurePolicy = failurePolicy;
    }

    public V1alpha1ValidatingAdmissionPolicySpec matchConditions(List<V1alpha1MatchCondition> matchConditions) {
        this.matchConditions = matchConditions;
        return this;
    }

    public V1alpha1ValidatingAdmissionPolicySpec addMatchConditionsItem(V1alpha1MatchCondition matchConditionsItem) {
        if (this.matchConditions == null) {
            this.matchConditions = new ArrayList<V1alpha1MatchCondition>();
        }
        this.matchConditions.add(matchConditionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="MatchConditions is a list of conditions that must be met for a request to be validated. Match conditions filter requests that have already been matched by the rules, namespaceSelector, and objectSelector. An empty list of matchConditions matches all requests. There are a maximum of 64 match conditions allowed.  If a parameter object is provided, it can be accessed via the `params` handle in the same manner as validation expressions.  The exact matching logic is (in order):   1. If ANY matchCondition evaluates to FALSE, the policy is skipped.   2. If ALL matchConditions evaluate to TRUE, the policy is evaluated.   3. If any matchCondition evaluates to an error (but none are FALSE):      - If failurePolicy=Fail, reject the request      - If failurePolicy=Ignore, the policy is skipped")
    public List<V1alpha1MatchCondition> getMatchConditions() {
        return this.matchConditions;
    }

    public void setMatchConditions(List<V1alpha1MatchCondition> matchConditions) {
        this.matchConditions = matchConditions;
    }

    public V1alpha1ValidatingAdmissionPolicySpec matchConstraints(V1alpha1MatchResources matchConstraints) {
        this.matchConstraints = matchConstraints;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1alpha1MatchResources getMatchConstraints() {
        return this.matchConstraints;
    }

    public void setMatchConstraints(V1alpha1MatchResources matchConstraints) {
        this.matchConstraints = matchConstraints;
    }

    public V1alpha1ValidatingAdmissionPolicySpec paramKind(V1alpha1ParamKind paramKind) {
        this.paramKind = paramKind;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1alpha1ParamKind getParamKind() {
        return this.paramKind;
    }

    public void setParamKind(V1alpha1ParamKind paramKind) {
        this.paramKind = paramKind;
    }

    public V1alpha1ValidatingAdmissionPolicySpec validations(List<V1alpha1Validation> validations) {
        this.validations = validations;
        return this;
    }

    public V1alpha1ValidatingAdmissionPolicySpec addValidationsItem(V1alpha1Validation validationsItem) {
        if (this.validations == null) {
            this.validations = new ArrayList<V1alpha1Validation>();
        }
        this.validations.add(validationsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Validations contain CEL expressions which is used to apply the validation. Validations and AuditAnnotations may not both be empty; a minimum of one Validations or AuditAnnotations is required.")
    public List<V1alpha1Validation> getValidations() {
        return this.validations;
    }

    public void setValidations(List<V1alpha1Validation> validations) {
        this.validations = validations;
    }

    public V1alpha1ValidatingAdmissionPolicySpec variables(List<V1alpha1Variable> variables) {
        this.variables = variables;
        return this;
    }

    public V1alpha1ValidatingAdmissionPolicySpec addVariablesItem(V1alpha1Variable variablesItem) {
        if (this.variables == null) {
            this.variables = new ArrayList<V1alpha1Variable>();
        }
        this.variables.add(variablesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Variables contain definitions of variables that can be used in composition of other expressions. Each variable is defined as a named CEL expression. The variables defined here will be available under `variables` in other expressions of the policy except MatchConditions because MatchConditions are evaluated before the rest of the policy.  The expression of a variable can refer to other variables defined earlier in the list but not those after. Thus, Variables must be sorted by the order of first appearance and acyclic.")
    public List<V1alpha1Variable> getVariables() {
        return this.variables;
    }

    public void setVariables(List<V1alpha1Variable> variables) {
        this.variables = variables;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha1ValidatingAdmissionPolicySpec v1alpha1ValidatingAdmissionPolicySpec = (V1alpha1ValidatingAdmissionPolicySpec)o;
        return Objects.equals(this.auditAnnotations, v1alpha1ValidatingAdmissionPolicySpec.auditAnnotations) && Objects.equals(this.failurePolicy, v1alpha1ValidatingAdmissionPolicySpec.failurePolicy) && Objects.equals(this.matchConditions, v1alpha1ValidatingAdmissionPolicySpec.matchConditions) && Objects.equals(this.matchConstraints, v1alpha1ValidatingAdmissionPolicySpec.matchConstraints) && Objects.equals(this.paramKind, v1alpha1ValidatingAdmissionPolicySpec.paramKind) && Objects.equals(this.validations, v1alpha1ValidatingAdmissionPolicySpec.validations) && Objects.equals(this.variables, v1alpha1ValidatingAdmissionPolicySpec.variables);
    }

    public int hashCode() {
        return Objects.hash(this.auditAnnotations, this.failurePolicy, this.matchConditions, this.matchConstraints, this.paramKind, this.validations, this.variables);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1alpha1ValidatingAdmissionPolicySpec {\n");
        sb.append("    auditAnnotations: ").append(this.toIndentedString(this.auditAnnotations)).append("\n");
        sb.append("    failurePolicy: ").append(this.toIndentedString(this.failurePolicy)).append("\n");
        sb.append("    matchConditions: ").append(this.toIndentedString(this.matchConditions)).append("\n");
        sb.append("    matchConstraints: ").append(this.toIndentedString(this.matchConstraints)).append("\n");
        sb.append("    paramKind: ").append(this.toIndentedString(this.paramKind)).append("\n");
        sb.append("    validations: ").append(this.toIndentedString(this.validations)).append("\n");
        sb.append("    variables: ").append(this.toIndentedString(this.variables)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayvariables;
        JsonArray jsonArrayvalidations;
        JsonArray jsonArraymatchConditions;
        int i;
        JsonArray jsonArrayauditAnnotations;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1alpha1ValidatingAdmissionPolicySpec is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1alpha1ValidatingAdmissionPolicySpec` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_AUDIT_ANNOTATIONS) != null && !jsonObj.get(SERIALIZED_NAME_AUDIT_ANNOTATIONS).isJsonNull() && (jsonArrayauditAnnotations = jsonObj.getAsJsonArray(SERIALIZED_NAME_AUDIT_ANNOTATIONS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_AUDIT_ANNOTATIONS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `auditAnnotations` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_AUDIT_ANNOTATIONS).toString()));
            }
            for (i = 0; i < jsonArrayauditAnnotations.size(); ++i) {
                V1alpha1AuditAnnotation.validateJsonElement(jsonArrayauditAnnotations.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_FAILURE_POLICY) != null && !jsonObj.get(SERIALIZED_NAME_FAILURE_POLICY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_FAILURE_POLICY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `failurePolicy` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_FAILURE_POLICY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_MATCH_CONDITIONS) != null && !jsonObj.get(SERIALIZED_NAME_MATCH_CONDITIONS).isJsonNull() && (jsonArraymatchConditions = jsonObj.getAsJsonArray(SERIALIZED_NAME_MATCH_CONDITIONS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_MATCH_CONDITIONS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `matchConditions` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_MATCH_CONDITIONS).toString()));
            }
            for (i = 0; i < jsonArraymatchConditions.size(); ++i) {
                V1alpha1MatchCondition.validateJsonElement(jsonArraymatchConditions.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_MATCH_CONSTRAINTS) != null && !jsonObj.get(SERIALIZED_NAME_MATCH_CONSTRAINTS).isJsonNull()) {
            V1alpha1MatchResources.validateJsonElement(jsonObj.get(SERIALIZED_NAME_MATCH_CONSTRAINTS));
        }
        if (jsonObj.get(SERIALIZED_NAME_PARAM_KIND) != null && !jsonObj.get(SERIALIZED_NAME_PARAM_KIND).isJsonNull()) {
            V1alpha1ParamKind.validateJsonElement(jsonObj.get(SERIALIZED_NAME_PARAM_KIND));
        }
        if (jsonObj.get(SERIALIZED_NAME_VALIDATIONS) != null && !jsonObj.get(SERIALIZED_NAME_VALIDATIONS).isJsonNull() && (jsonArrayvalidations = jsonObj.getAsJsonArray(SERIALIZED_NAME_VALIDATIONS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_VALIDATIONS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `validations` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VALIDATIONS).toString()));
            }
            for (i = 0; i < jsonArrayvalidations.size(); ++i) {
                V1alpha1Validation.validateJsonElement(jsonArrayvalidations.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_VARIABLES) != null && !jsonObj.get(SERIALIZED_NAME_VARIABLES).isJsonNull() && (jsonArrayvariables = jsonObj.getAsJsonArray(SERIALIZED_NAME_VARIABLES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_VARIABLES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `variables` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VARIABLES).toString()));
            }
            for (i = 0; i < jsonArrayvariables.size(); ++i) {
                V1alpha1Variable.validateJsonElement(jsonArrayvariables.get(i));
            }
        }
    }

    public static V1alpha1ValidatingAdmissionPolicySpec fromJson(String jsonString) throws IOException {
        return (V1alpha1ValidatingAdmissionPolicySpec)JSON.getGson().fromJson(jsonString, V1alpha1ValidatingAdmissionPolicySpec.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_AUDIT_ANNOTATIONS);
        openapiFields.add(SERIALIZED_NAME_FAILURE_POLICY);
        openapiFields.add(SERIALIZED_NAME_MATCH_CONDITIONS);
        openapiFields.add(SERIALIZED_NAME_MATCH_CONSTRAINTS);
        openapiFields.add(SERIALIZED_NAME_PARAM_KIND);
        openapiFields.add(SERIALIZED_NAME_VALIDATIONS);
        openapiFields.add(SERIALIZED_NAME_VARIABLES);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1alpha1ValidatingAdmissionPolicySpec.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1alpha1ValidatingAdmissionPolicySpec.class));
            return new TypeAdapter<V1alpha1ValidatingAdmissionPolicySpec>(){

                public void write(JsonWriter out, V1alpha1ValidatingAdmissionPolicySpec value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1alpha1ValidatingAdmissionPolicySpec read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1alpha1ValidatingAdmissionPolicySpec.validateJsonElement(jsonElement);
                    return (V1alpha1ValidatingAdmissionPolicySpec)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

